/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversion;
import adams.data.matlab.MatlabUtils;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import us.hebi.matlab.mat.types.AbstractCharBase;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;
import us.hebi.matlab.mat.types.Char;
import us.hebi.matlab.mat.types.Matrix;

public class Mat5ArrayToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = -2006396004849089721L;

    public String globalInfo() {
        return "Turns the Matlab array into a spreadsheet.";
    }

    public Class accepts() {
        return Array.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected String checkData() {
        Array array;
        Object result = super.checkData();
        if (result == null && (array = (Array)this.m_Input).getNumDimensions() > 2) {
            result = "Cannot handle arrays with more than two dimensions, received: " + array.getNumDimensions();
        }
        return result;
    }

    protected Object doConvert() throws Exception {
        int i;
        Array array = (Array)this.m_Input;
        Matrix matrix = null;
        if (array instanceof Matrix) {
            matrix = (Matrix)array;
        }
        Cell matCell = null;
        if (array instanceof Cell) {
            matCell = (Cell)array;
        }
        Char matChar = null;
        if (array instanceof Char) {
            matChar = (Char)array;
        }
        if (matrix == null && matCell == null && matChar == null) {
            throw new IllegalStateException("Unhandled array type: " + Utils.classToString((Object)array));
        }
        if (matChar != null) {
            String[] lines = MatlabUtils.charToString(matChar).split("\n");
            DefaultSpreadSheet result = new DefaultSpreadSheet();
            HeaderRow row = result.getHeaderRow();
            row.addCell("0").setContentAsString("Line");
            for (String line : lines) {
                result.addRow().addCell("0").setContentAsString(line);
            }
            return result;
        }
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        for (i = 0; i < array.getNumCols(); ++i) {
            row.addCell("" + i).setContentAsString("col-" + (i + 1));
        }
        for (int n = 0; n < array.getNumRows(); ++n) {
            row = result.addRow();
            for (i = 0; i < array.getNumCols(); ++i) {
                adams.data.spreadsheet.Cell cell = row.addCell(i);
                if (matrix != null) {
                    cell.setContent(Double.valueOf(matrix.getDouble(n, i)));
                    continue;
                }
                if (matCell != null) {
                    if (matCell.get(n, i) instanceof AbstractCharBase) {
                        cell.setContent(MatlabUtils.charToString((Char)((AbstractCharBase)matCell.get(n, i))));
                        continue;
                    }
                    cell.setContent(matCell.get(n, i).toString());
                    continue;
                }
                if (matChar == null) continue;
                cell.setContentAsString("" + matChar.getChar(n, i));
            }
        }
        return result;
    }
}

