/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversionToString;
import adams.data.matlab.ArrayElementType;
import adams.data.matlab.MatlabUtils;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Matrix;

public class Mat5ArrayToString
extends AbstractConversionToString {
    private static final long serialVersionUID = -5951006048504569301L;
    protected ArrayElementType m_ElementType;
    protected boolean m_Compact;
    protected int m_NumDecimals;

    public String globalInfo() {
        return "Converts matrices into a textual representation, otherwise just outputs the dimensions.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("element-type", "elementType", (Object)ArrayElementType.DOUBLE);
        this.m_OptionManager.add("compact", "compact", (Object)false);
        this.m_OptionManager.add("num-decimals", "numDecimals", (Object)-1, (Number)-1, null);
    }

    public void setElementType(ArrayElementType value) {
        this.m_ElementType = value;
        this.reset();
    }

    public ArrayElementType getElementType() {
        return this.m_ElementType;
    }

    public String elementTypeTipText() {
        return "Specifies the type of the values in the array.";
    }

    public void setCompact(boolean value) {
        this.m_Compact = value;
        this.reset();
    }

    public boolean getCompact() {
        return this.m_Compact;
    }

    public String compactTipText() {
        return "If enabled, the output omits spaces.";
    }

    public void setNumDecimals(int value) {
        if (this.getOptionManager().isValid("numDecimals", (Number)value)) {
            this.m_NumDecimals = value;
            this.reset();
        }
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals after the decimal point to use; -1 means automatic.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"elementType", (Object)((Object)this.m_ElementType), (String)"element: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"compact", (boolean)this.m_Compact, (String)"compact", (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"numDecimals", (Object)(this.m_NumDecimals == -1 ? "auto" : "" + this.m_NumDecimals), (String)", #decimals: ");
        return result;
    }

    public Class accepts() {
        return Array.class;
    }

    protected String checkData() {
        Object result = super.checkData();
        if (result == null && !(this.m_Input instanceof Matrix)) {
            result = "Expected " + Utils.classToString(Matrix.class) + " but got " + Utils.classToString((Object)this.m_Input);
        }
        return result;
    }

    protected Object doConvert() throws Exception {
        StringBuilder result = new StringBuilder();
        Matrix input = (Matrix)this.m_Input;
        if (input.getNumDimensions() == 2) {
            int numRows = input.getNumRows();
            int numCols = input.getNumCols();
            int[] index = new int[2];
            result.append("[");
            for (int y = 0; y < numRows; ++y) {
                if (y > 0) {
                    result.append(";");
                    if (!this.m_Compact) {
                        result.append(" ");
                    }
                }
                for (int x = 0; x < numCols; ++x) {
                    if (x > 0) {
                        result.append(",");
                        if (!this.m_Compact) {
                            result.append(" ");
                        }
                    }
                    index[0] = y;
                    index[1] = x;
                    Object value = MatlabUtils.getElement(input, index, this.m_ElementType);
                    if (this.m_NumDecimals > -1 && value instanceof Number) {
                        value = Utils.doubleToString((double)((Number)value).doubleValue(), (int)this.m_NumDecimals);
                    }
                    result.append(value);
                }
            }
            result.append("]");
        } else {
            result.append(MatlabUtils.arrayDimensionsToString((Array)input));
        }
        return result.toString();
    }
}

