/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import java.util.HashMap;
import java.util.Map;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.Struct;

public class Mat5FileToMap
extends AbstractConversion {
    private static final long serialVersionUID = 448419021229335154L;

    public String globalInfo() {
        return "Turns the Mat5File data structure into a nested map.";
    }

    public Class accepts() {
        return Mat5File.class;
    }

    public Class generates() {
        return Map.class;
    }

    protected void addStruct(Map map, Struct struct) {
        for (String field : struct.getFieldNames()) {
            Array obj = struct.get(field);
            if (obj instanceof Struct) {
                HashMap submap = new HashMap();
                map.put(field, submap);
                this.addStruct(submap, (Struct)obj);
                continue;
            }
            map.put(field, obj);
        }
    }

    protected Object doConvert() throws Exception {
        HashMap result = new HashMap();
        Mat5File mat5 = (Mat5File)this.m_Input;
        for (MatFile.Entry entry : mat5.getEntries()) {
            if (entry.getValue() instanceof Struct) {
                HashMap submap = new HashMap();
                result.put(entry.getName(), submap);
                this.addStruct(submap, (Struct)entry.getValue());
                continue;
            }
            result.put(entry.getName(), entry.getValue());
        }
        return result;
    }
}

