/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.base.Mat5ArrayElementIndex;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.matlab.MatlabArrayIndexSupporter;
import java.util.HashMap;
import java.util.Map;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Struct;

public class Mat5StructToMap
extends AbstractConversion
implements MatlabArrayIndexSupporter {
    private static final long serialVersionUID = -2006396004849089721L;
    protected Mat5ArrayElementIndex m_Index;
    protected boolean m_ZeroBasedIndex;

    public String globalInfo() {
        return "Turns the Matlab struct into a map.\nIn case of multi-dimensional (outermost) structs, an index can be supplied to retrieve just a single element instead of all of them. Appends [x] or [y,x] to the field names, using 0-based indices.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", (Object)new Mat5ArrayElementIndex());
        this.m_OptionManager.add("zero-based-index", "zeroBasedIndex", (Object)false);
    }

    @Override
    public void setIndex(Mat5ArrayElementIndex value) {
        this.m_Index = value;
        this.reset();
    }

    @Override
    public Mat5ArrayElementIndex getIndex() {
        return this.m_Index;
    }

    @Override
    public String indexTipText() {
        return "The (optional) index for multi-dimensional structs to retrieve a single element instead of all.";
    }

    @Override
    public void setZeroBasedIndex(boolean value) {
        this.m_ZeroBasedIndex = value;
        this.reset();
    }

    @Override
    public boolean getZeroBasedIndex() {
        return this.m_ZeroBasedIndex;
    }

    @Override
    public String zeroBasedIndexTipText() {
        return "If true, the index is treated as 0-based (eg 0;0 for first value) rather than 1-based ones (eg 1;1 for first value).";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"index", (Object)(this.m_Index.isEmpty() ? "-none-" : this.m_Index.getValue()), (String)"index: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"zeroBasedIndex", (Object)(this.m_ZeroBasedIndex ? "0-based" : "1-based"), (String)", ");
        return result;
    }

    public Class accepts() {
        return Struct.class;
    }

    public Class generates() {
        return Map.class;
    }

    protected void addStruct(Map map, Struct struct, int[] index) {
        if (struct.getNumDimensions() > 2) {
            this.getLogger().warning("Cannot handle structs with more than 2 dimensions, skipping: " + struct);
            return;
        }
        int[] dims = struct.getDimensions();
        if (index != null && index.length != dims.length) {
            throw new IllegalStateException("Dimensions of index and struct differ: " + index.length + " != " + dims.length);
        }
        Object suffix = "";
        switch (dims.length) {
            case 1: {
                for (String field : struct.getFieldNames()) {
                    Array obj;
                    if (index != null) {
                        obj = struct.get(field, index[0]);
                        if (dims[0] > 1) {
                            suffix = "" + index[0];
                        }
                    } else {
                        obj = struct.get(field);
                    }
                    if (obj instanceof Struct) {
                        HashMap submap = new HashMap();
                        map.put(field + (String)suffix, submap);
                        this.addStruct(submap, (Struct)obj, null);
                        continue;
                    }
                    map.put(field + (String)suffix, obj);
                }
                break;
            }
            case 2: {
                int[] rangeX;
                int[] rangeY;
                if (index != null) {
                    rangeY = new int[]{index[0], index[0] + 1};
                    rangeX = new int[]{index[1], index[1] + 1};
                } else {
                    rangeY = new int[]{0, dims[0]};
                    rangeX = new int[]{0, dims[1]};
                }
                for (int y = rangeY[0]; y < rangeY[1]; ++y) {
                    for (int x = rangeX[0]; x < rangeX[1]; ++x) {
                        for (String field : struct.getFieldNames()) {
                            Array obj = struct.get(field, y, x);
                            if ((dims[0] > 1 || dims[1] > 1) && index == null) {
                                suffix = "[" + y + "," + x + "]";
                            }
                            if (obj instanceof Struct) {
                                HashMap submap = new HashMap();
                                map.put(field + (String)suffix, submap);
                                this.addStruct(submap, (Struct)obj, null);
                                continue;
                            }
                            map.put(field + (String)suffix, obj);
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled number of dimensions: " + dims.length);
            }
        }
    }

    protected Object doConvert() throws Exception {
        HashMap result = new HashMap();
        Struct struct = (Struct)this.m_Input;
        int[] index = this.m_Index.isEmpty() ? null : this.m_Index.indexValue(!this.m_ZeroBasedIndex);
        this.addStruct(result, struct, index);
        return result;
    }
}

