/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.SpreadSheet;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;

public class SpreadSheetHeaderToMat5Array
extends AbstractConversion {
    private static final long serialVersionUID = 6039846859150610999L;

    public String globalInfo() {
        return "Converts the spreadsheet header with the column names into a Matlab array.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return Array.class;
    }

    protected Object doConvert() throws Exception {
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        Cell result = Mat5.newCell((int[])new int[]{1, sheet.getColumnCount()});
        for (int i = 0; i < sheet.getColumnCount(); ++i) {
            result.set(i, (Array)Mat5.newString((String)sheet.getColumnName(i)));
        }
        return result;
    }
}

