/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.SpreadSheet;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;
import us.hebi.matlab.mat.types.Matrix;

public class SpreadSheetToMat5Array
extends AbstractConversion {
    private static final long serialVersionUID = 1720918361869379610L;

    public String globalInfo() {
        return "Converts a spreadsheet to a Matlab array (either matrix or a cell array)";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return Array.class;
    }

    protected Object doConvert() throws Exception {
        Matrix result;
        int i;
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        boolean numeric = true;
        for (i = 0; i < sheet.getColumnCount(); ++i) {
            if (sheet.isNumeric(i)) continue;
            numeric = false;
            break;
        }
        if (numeric) {
            Matrix matrix = Mat5.newMatrix((int[])new int[]{sheet.getRowCount(), sheet.getColumnCount()});
            for (int n = 0; n < sheet.getRowCount(); ++n) {
                for (i = 0; i < sheet.getColumnCount(); ++i) {
                    if (!sheet.hasCell(n, i) || sheet.getCell(n, i).isMissing()) {
                        matrix.setDouble(n, i, Double.NaN);
                        continue;
                    }
                    matrix.setDouble(n, i, sheet.getCell(n, i).toDouble().doubleValue());
                }
            }
            result = matrix;
        } else {
            Cell cell = Mat5.newCell((int[])new int[]{sheet.getRowCount(), sheet.getColumnCount()});
            for (int n = 0; n < sheet.getRowCount(); ++n) {
                for (i = 0; i < sheet.getColumnCount(); ++i) {
                    if (!sheet.hasCell(n, i) || sheet.getCell(n, i).isMissing()) {
                        cell.set(n, i, (Array)Mat5.newScalar((double)Double.NaN));
                        continue;
                    }
                    if (sheet.getCell(n, i).isNumeric()) {
                        cell.set(n, i, (Array)Mat5.newScalar((double)sheet.getCell(n, i).toDouble()));
                        continue;
                    }
                    cell.set(n, i, (Array)Mat5.newString((String)sheet.getCell(n, i).getContent()));
                }
            }
            result = cell;
        }
        return result;
    }
}

