/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversionFromString;
import adams.data.matlab.ArrayElementType;
import adams.data.matlab.MatlabUtils;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Matrix;

public class StringToMat5Array
extends AbstractConversionFromString {
    private static final long serialVersionUID = 328317728225004681L;
    protected ArrayElementType m_ElementType;

    public String globalInfo() {
        return "Converts a string like '[1, 2; 3, 4]' into a Matlab matrix.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("element-type", "elementType", (Object)ArrayElementType.DOUBLE);
    }

    public void setElementType(ArrayElementType value) {
        this.m_ElementType = value;
        this.reset();
    }

    public ArrayElementType getElementType() {
        return this.m_ElementType;
    }

    public String elementTypeTipText() {
        return "Specifies the type of the values in the array.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"elementType", (Object)((Object)this.m_ElementType), (String)"element: ");
    }

    public Class generates() {
        return Array.class;
    }

    protected String checkData() {
        Object result = super.checkData();
        if (result == null) {
            String input = (String)this.m_Input;
            if (!(input = input.trim()).startsWith("[") || !input.endsWith("]")) {
                result = "Expected input to start with '[' and end with ']', but received: " + input;
            }
        }
        return result;
    }

    protected Object doConvert() throws Exception {
        Matrix result = null;
        String input = (String)this.m_Input;
        input = input.substring(1, input.length() - 1);
        String[] lines = input.replace(" ", "").split(";");
        int[] index = new int[2];
        for (int y = 0; y < lines.length; ++y) {
            String[] cells = lines[y].split(",");
            if (result == null) {
                result = Mat5.newMatrix((int[])new int[]{lines.length, cells.length});
            }
            int x = 0;
            while (x < cells.length) {
                Comparable<Boolean> value;
                switch (this.m_ElementType) {
                    case BOOLEAN: {
                        value = Boolean.parseBoolean(cells[x]);
                        break;
                    }
                    case BYTE: {
                        value = Byte.parseByte(cells[x]);
                        break;
                    }
                    case SHORT: {
                        value = Short.parseShort(cells[x]);
                        break;
                    }
                    case INTEGER: {
                        value = Integer.parseInt(cells[x]);
                        break;
                    }
                    case LONG: {
                        value = Long.parseLong(cells[x]);
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(Float.parseFloat(cells[x]));
                        break;
                    }
                    case DOUBLE: {
                        value = Double.parseDouble(cells[x]);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled element type: " + this.m_ElementType);
                    }
                }
                index[0] = y;
                index[1] = x++;
                MatlabUtils.setElement(result, index, this.m_ElementType, value);
            }
        }
        return result;
    }
}

