/*
 * Decompiled with CFR 0.152.
 */
package adams.data.matlab;

import adams.data.matlab.ArrayElementType;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Char;
import us.hebi.matlab.mat.types.Matrix;

public class MatlabUtils {
    public static String charToString(Char matChar) {
        StringBuilder result = new StringBuilder();
        int rows = matChar.getNumRows();
        int cols = matChar.getNumCols();
        for (int y = 0; y < rows; ++y) {
            if (y > 0) {
                result.append("\n");
            }
            for (int x = 0; x < cols; ++x) {
                result.append(matChar.getChar(y, x));
            }
        }
        return result.toString();
    }

    public static boolean increment(int[] index, int[] dims) {
        int pos;
        int n = pos = index.length - 1;
        index[n] = index[n] + 1;
        while (index[pos] >= dims[pos]) {
            if (pos == 0) {
                return true;
            }
            index[pos] = 0;
            int n2 = --pos;
            index[n2] = index[n2] + 1;
        }
        return false;
    }

    public static boolean increment(int[] index, int[] dims, int[] open) {
        int pos = open.length - 1;
        int n = open[pos];
        index[n] = index[n] + 1;
        while (index[open[pos]] >= dims[open[pos]]) {
            if (pos == 0) {
                return true;
            }
            index[open[pos]] = 0;
            int n2 = open[--pos];
            index[n2] = index[n2] + 1;
        }
        return false;
    }

    public static void transfer(Matrix source, int[] sourceIndex, Matrix target, int[] targetIndex, ArrayElementType type) {
        switch (type) {
            case BOOLEAN: {
                target.setBoolean(targetIndex, source.getBoolean(sourceIndex));
                break;
            }
            case BYTE: {
                target.setByte(targetIndex, source.getByte(sourceIndex));
                break;
            }
            case SHORT: {
                target.setShort(targetIndex, source.getShort(sourceIndex));
                break;
            }
            case INTEGER: {
                target.setInt(targetIndex, source.getInt(sourceIndex));
                break;
            }
            case LONG: {
                target.setLong(targetIndex, source.getLong(sourceIndex));
                break;
            }
            case FLOAT: {
                target.setFloat(targetIndex, source.getFloat(sourceIndex));
                break;
            }
            case DOUBLE: {
                target.setDouble(targetIndex, source.getDouble(sourceIndex));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled element type: " + type);
            }
        }
    }

    public static void transfer(Matrix source, int[] dimsSource, int[] openSource, int[] indexSource, Matrix target, int[] dimsTarget, ArrayElementType type) {
        boolean finished = false;
        int[] indexTarget = new int[dimsTarget.length];
        while (!finished) {
            for (int i = 0; i < indexTarget.length; ++i) {
                indexSource[openSource[i]] = indexTarget[i];
            }
            MatlabUtils.transfer(source, indexSource, target, indexTarget, type);
            finished = MatlabUtils.increment(indexTarget, dimsTarget);
        }
    }

    public static void transfer(Matrix source, int[] indexSource, int[] dimsSource, int[] openSource, Matrix target, int[] indexTarget, int[] dimsTarget, int[] openTarget, ArrayElementType type) {
        if (indexSource == null) {
            indexSource = new int[dimsSource.length];
        }
        if (indexTarget == null) {
            indexTarget = new int[dimsTarget.length];
        }
        boolean finished = false;
        while (!finished) {
            MatlabUtils.transfer(source, indexSource, target, indexTarget, type);
            finished = MatlabUtils.increment(indexSource, dimsSource, openSource);
            MatlabUtils.increment(indexTarget, dimsTarget, openTarget);
        }
    }

    public static Object getElement(Matrix source, int[] index, ArrayElementType type) {
        switch (type) {
            case BOOLEAN: {
                return source.getBoolean(index);
            }
            case BYTE: {
                return source.getByte(index);
            }
            case SHORT: {
                return source.getShort(index);
            }
            case INTEGER: {
                return source.getInt(index);
            }
            case LONG: {
                return source.getLong(index);
            }
            case FLOAT: {
                return Float.valueOf(source.getFloat(index));
            }
            case DOUBLE: {
                return source.getDouble(index);
            }
        }
        throw new IllegalStateException("Unhandled element type: " + type);
    }

    public static String setElement(Matrix target, int[] index, ArrayElementType type, Object value) {
        String result = null;
        try {
            if (value instanceof String) {
                switch (type) {
                    case BOOLEAN: {
                        value = Boolean.parseBoolean((String)value);
                        break;
                    }
                    case BYTE: {
                        value = Byte.parseByte((String)value);
                        break;
                    }
                    case SHORT: {
                        value = Short.parseShort((String)value);
                        break;
                    }
                    case INTEGER: {
                        value = Integer.parseInt((String)value);
                        break;
                    }
                    case LONG: {
                        value = Long.parseLong((String)value);
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(Float.parseFloat((String)value));
                        break;
                    }
                    case DOUBLE: {
                        value = Double.parseDouble((String)value);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled element type: " + type);
                    }
                }
            }
            switch (type) {
                case BOOLEAN: {
                    target.setBoolean(index, ((Boolean)value).booleanValue());
                    break;
                }
                case BYTE: {
                    target.setByte(index, ((Byte)value).byteValue());
                    break;
                }
                case SHORT: {
                    target.setShort(index, ((Short)value).shortValue());
                    break;
                }
                case INTEGER: {
                    target.setInt(index, ((Integer)value).intValue());
                    break;
                }
                case LONG: {
                    target.setLong(index, ((Long)value).longValue());
                    break;
                }
                case FLOAT: {
                    target.setFloat(index, ((Float)value).floatValue());
                    break;
                }
                case DOUBLE: {
                    target.setDouble(index, ((Double)value).doubleValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled element type: " + type);
                }
            }
        }
        catch (Exception e) {
            result = "Failed to set ";
        }
        return result;
    }

    public static String arrayDimensionsToString(Array array) {
        return MatlabUtils.arrayDimensionsToString(array, "x");
    }

    public static String arrayDimensionsToString(Array array, String separator) {
        StringBuilder result = new StringBuilder();
        for (int dim : array.getDimensions()) {
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(dim);
        }
        return result.toString();
    }
}

