/*
 * Decompiled with CFR 0.152.
 */
package adams.data.matlab.multimatrixoperation;

import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.data.matlab.MatlabUtils;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Matrix;

public abstract class AbstractMultiMatrixOperation
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = 1185449853784824033L;

    public String getQuickInfo() {
        return null;
    }

    public abstract int minNumMatricesRequired();

    public abstract int maxNumMatricesRequired();

    protected boolean checkSameDimensions(Matrix array1, Matrix array2) {
        return MatlabUtils.arrayDimensionsToString((Array)array1).equals(MatlabUtils.arrayDimensionsToString((Array)array2));
    }

    protected String checkSameDimensions(Matrix[] matrices) {
        for (int i = 1; i < matrices.length; ++i) {
            if (this.checkSameDimensions(matrices[0], matrices[i])) continue;
            return "All matrices need to have the same dimensions: " + MatlabUtils.arrayDimensionsToString((Array)matrices[0]) + " (#1) != " + MatlabUtils.arrayDimensionsToString((Array)matrices[i]) + "(#" + (i + 1) + ")";
        }
        return null;
    }

    protected void check(Matrix[] matrices) {
        if (matrices == null || matrices.length == 0) {
            throw new IllegalStateException("No matrices provided!");
        }
        if (this.minNumMatricesRequired() > 0 && matrices.length < this.minNumMatricesRequired()) {
            throw new IllegalStateException("Not enough matrices supplied (min > supplied): " + this.minNumMatricesRequired() + " > " + matrices.length);
        }
        if (this.maxNumMatricesRequired() > 0 && matrices.length > this.maxNumMatricesRequired()) {
            throw new IllegalStateException("Too many matrices supplied (max < supplied): " + this.maxNumMatricesRequired() + " < " + matrices.length);
        }
    }

    protected abstract Matrix[] doProcess(Matrix[] var1);

    public Matrix[] process(Matrix[] matrices) {
        this.check(matrices);
        return this.doProcess(matrices);
    }
}

