/*
 * Decompiled with CFR 0.152.
 */
package adams.data.matlab.multimatrixoperation;

import adams.data.matlab.MatlabUtils;
import adams.data.matlab.multimatrixoperation.AbstractMultiMatrixOperation;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.types.Matrix;

public class Add
extends AbstractMultiMatrixOperation {
    private static final long serialVersionUID = 8924493141315007273L;

    public String globalInfo() {
        return "Performs element-wise addition and outputs the result as single matrix.";
    }

    @Override
    public int minNumMatricesRequired() {
        return 2;
    }

    @Override
    public int maxNumMatricesRequired() {
        return 0;
    }

    @Override
    protected Matrix[] doProcess(Matrix[] matrices) {
        int[] dims = matrices[0].getDimensions();
        int[] index = new int[dims.length];
        Matrix[] result = new Matrix[]{Mat5.newMatrix((int[])dims)};
        boolean finished = false;
        while (!finished) {
            double sum = 0.0;
            for (Matrix matrix : matrices) {
                sum += matrix.getDouble(index);
            }
            result[0].setDouble(index, sum);
            finished = MatlabUtils.increment(index, dims);
        }
        return result;
    }
}

