/*
 * Decompiled with CFR 0.152.
 */
package adams.data.matlab.multimatrixoperation;

import adams.data.matlab.MatlabUtils;
import adams.data.matlab.multimatrixoperation.AbstractMultiMatrixOperation;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.types.Matrix;

public class ApplyMask
extends AbstractMultiMatrixOperation {
    private static final long serialVersionUID = 8924493141315007273L;

    public String globalInfo() {
        return "Uses the second matrix as mask that gets applied to the first matrix.\nElements from the first matrix are only kept if the corresponding ones in the mask are non-zero.";
    }

    @Override
    public int minNumMatricesRequired() {
        return 2;
    }

    @Override
    public int maxNumMatricesRequired() {
        return 2;
    }

    @Override
    protected Matrix[] doProcess(Matrix[] matrices) {
        int[] dims = matrices[0].getDimensions();
        int[] index = new int[dims.length];
        Matrix[] result = new Matrix[]{Mat5.newMatrix((int[])dims)};
        boolean finished = false;
        while (!finished) {
            if (matrices[1].getDouble(index) == 0.0) {
                result[0].setDouble(index, 0.0);
            } else {
                result[0].setDouble(index, matrices[0].getDouble(index));
            }
            finished = MatlabUtils.increment(index, dims);
        }
        return result;
    }
}

