/*
 * Decompiled with CFR 0.152.
 */
package adams.data.matlab.multimatrixoperation;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.matlab.ArrayElementType;
import adams.data.matlab.MatlabUtils;
import adams.data.matlab.multimatrixoperation.AbstractMultiMatrixOperation;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.types.Matrix;

public class Combine
extends AbstractMultiMatrixOperation {
    private static final long serialVersionUID = 8924493141315007273L;
    protected ArrayElementType m_ElementType;

    public String globalInfo() {
        return "Combines the matrices into single one with additional dimension.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("element-type", "elementType", (Object)ArrayElementType.DOUBLE);
    }

    public void setElementType(ArrayElementType value) {
        this.m_ElementType = value;
        this.reset();
    }

    public ArrayElementType getElementType() {
        return this.m_ElementType;
    }

    public String elementTypeTipText() {
        return "Specifies the type of the values in the array.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"elementType", (Object)((Object)this.m_ElementType), (String)"element: ");
    }

    @Override
    public int minNumMatricesRequired() {
        return 1;
    }

    @Override
    public int maxNumMatricesRequired() {
        return 0;
    }

    @Override
    protected Matrix[] doProcess(Matrix[] matrices) {
        int i;
        int[] inputDims = matrices[0].getDimensions();
        int[] outputDims = new int[inputDims.length + 1];
        System.arraycopy(inputDims, 0, outputDims, 0, inputDims.length);
        outputDims[outputDims.length - 1] = matrices.length;
        int[] inputOpen = new int[inputDims.length];
        int[] outputOpen = new int[inputDims.length];
        int[] inputIndex = new int[inputDims.length];
        int[] outputIndex = new int[outputDims.length];
        for (i = 0; i < inputDims.length; ++i) {
            inputOpen[i] = i;
            outputOpen[i] = i;
        }
        Matrix[] result = new Matrix[]{Mat5.newMatrix((int[])outputDims)};
        for (i = 0; i < matrices.length; ++i) {
            outputIndex[outputIndex.length - 1] = i;
            MatlabUtils.transfer(matrices[i], (int[])inputIndex.clone(), inputDims, inputOpen, result[0], (int[])outputIndex.clone(), outputDims, outputOpen, this.m_ElementType);
        }
        return result;
    }
}

