/*
 * Decompiled with CFR 0.152.
 */
package adams.data.matlab.multimatrixoperation;

import adams.data.matlab.MatlabUtils;
import adams.data.matlab.multimatrixoperation.AbstractMultiMatrixOperation;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.types.Matrix;

public class Subtract
extends AbstractMultiMatrixOperation {
    private static final long serialVersionUID = 8924493141315007273L;

    public String globalInfo() {
        return "Performs element-wise subtraction and outputs the result as single matrix.\nElements of matrices 1-n are subtracted from matrix 0.";
    }

    @Override
    public int minNumMatricesRequired() {
        return 2;
    }

    @Override
    public int maxNumMatricesRequired() {
        return 0;
    }

    @Override
    protected Matrix[] doProcess(Matrix[] matrices) {
        int[] dims = matrices[0].getDimensions();
        int[] index = new int[dims.length];
        Matrix[] result = new Matrix[]{Mat5.newMatrix((int[])dims)};
        boolean finished = false;
        while (!finished) {
            double value = matrices[0].getDouble(index);
            for (int i = 1; i < matrices.length; ++i) {
                value -= matrices[i].getDouble(index);
            }
            result[0].setDouble(index, value);
            finished = MatlabUtils.increment(index, dims);
        }
        return result;
    }
}

