/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.base.Mat5ArrayDimensions;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.types.Struct;

public class NewMat5Struct
extends AbstractSimpleSource {
    private static final long serialVersionUID = -3376485047370616035L;
    protected Mat5ArrayDimensions m_Dimensions;

    public String globalInfo() {
        return "Creates a new Matlab struct.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dimensions", "dimensions", (Object)new Mat5ArrayDimensions("1;1"));
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"dimensions", (Object)((Object)this.m_Dimensions), (String)"dims: ");
        return result;
    }

    public void setDimensions(Mat5ArrayDimensions value) {
        this.m_Dimensions = value;
        this.reset();
    }

    public Mat5ArrayDimensions getDimensions() {
        return this.m_Dimensions;
    }

    public String dimensionsTipText() {
        return "The dimensions of the struct.";
    }

    public Class[] generates() {
        return new Class[]{Struct.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_OutputToken = new Token((Object)Mat5.newStruct((int[])this.m_Dimensions.indexValue()));
        }
        catch (Exception e) {
            result = this.handleException("Failed to create struct using dimensions: " + this.m_Dimensions, e);
        }
        return result;
    }
}

