/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.matlab.MatlabUtils;
import adams.flow.core.DataInfoActor;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.hebi.matlab.mat.types.Array;

public class Mat5ArrayInfo
extends AbstractArrayProvider
implements DataInfoActor {
    private static final long serialVersionUID = 8251699709312918726L;
    protected InfoType m_Type;
    protected String m_DimSeparator;

    public String globalInfo() {
        return "Provides information on a Matlab5 array.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.NUM_DIMENSIONS);
        this.m_OptionManager.add("dim-separator", "dimSeparator", (Object)"x");
    }

    public String outputArrayTipText() {
        return "If enabled, outputs the items as array rather than one-by-one.";
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public void setDimSeparator(String value) {
        this.m_DimSeparator = value;
        this.reset();
    }

    public String getDimSeparator() {
        return this.m_DimSeparator;
    }

    public String dimSeparatorTipText() {
        return "The separator to use for the dimensions when outputting " + InfoType.STR_DIMENSIONS + ".";
    }

    public Class[] accepts() {
        return new Class[]{Array.class};
    }

    protected Class getItemClass() {
        switch (this.m_Type) {
            case ALL: {
                return Map.class;
            }
            case TYPE_NAME: 
            case STR_DIMENSIONS: {
                return String.class;
            }
            case TYPE_ID: 
            case NUM_DIMENSIONS: 
            case NUM_COLS: 
            case NUM_ROWS: 
            case DIMENSIONS: 
            case NUM_ELEMENTS: {
                return Integer.class;
            }
        }
        throw new IllegalStateException("Unhandled info type: " + this.m_Type);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"dimSeparator", (Object)this.m_DimSeparator, (String)", dim sep: ");
        return result;
    }

    protected List getInfo(Array array, InfoType type) {
        ArrayList<Object> result = new ArrayList<Object>();
        switch (type) {
            case ALL: {
                break;
            }
            case TYPE_NAME: {
                result.add(array.getType().name());
                break;
            }
            case TYPE_ID: {
                result.add(array.getType().id());
                break;
            }
            case NUM_DIMENSIONS: {
                result.add(array.getNumDimensions());
                break;
            }
            case STR_DIMENSIONS: {
                result.add(MatlabUtils.arrayDimensionsToString(array, this.m_DimSeparator));
                break;
            }
            case NUM_COLS: {
                result.add(array.getNumCols());
                break;
            }
            case NUM_ROWS: {
                result.add(array.getNumRows());
                break;
            }
            case NUM_ELEMENTS: {
                result.add(array.getNumElements());
                break;
            }
            case DIMENSIONS: {
                for (int dim : array.getDimensions()) {
                    result.add(dim);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled info type: " + type);
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        Array array = (Array)this.m_InputToken.getPayload(Array.class);
        try {
            this.m_Queue.clear();
            switch (this.m_Type) {
                case ALL: {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (InfoType type : InfoType.values()) {
                        if (type == InfoType.ALL) continue;
                        List info = this.getInfo(array, type);
                        if (info.size() == 1) {
                            map.put(type.name(), info.get(0));
                            continue;
                        }
                        map.put(type.name(), info.toArray());
                    }
                    this.m_Queue.add(map);
                    break;
                }
                case TYPE_NAME: 
                case STR_DIMENSIONS: 
                case TYPE_ID: 
                case NUM_DIMENSIONS: 
                case NUM_COLS: 
                case NUM_ROWS: 
                case DIMENSIONS: 
                case NUM_ELEMENTS: {
                    this.m_Queue.addAll(this.getInfo(array, this.m_Type));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled info type: " + this.m_Type);
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate information: " + this.m_Type, e);
        }
        return result;
    }

    public static enum InfoType {
        ALL,
        TYPE_NAME,
        TYPE_ID,
        NUM_DIMENSIONS,
        STR_DIMENSIONS,
        NUM_COLS,
        NUM_ROWS,
        NUM_ELEMENTS,
        DIMENSIONS;

    }
}

