/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.Mat5ArrayElementIndex;
import adams.core.option.OptionHandler;
import adams.data.matlab.ArrayElementType;
import adams.data.matlab.MatlabArrayIndexSupporter;
import adams.data.matlab.MatlabUtils;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Matrix;

public class Mat5ArraySubset
extends AbstractTransformer
implements MatlabArrayIndexSupporter {
    private static final long serialVersionUID = -1043266053222175480L;
    protected Mat5ArrayElementIndex m_Index;
    protected boolean m_ZeroBasedIndex;
    protected ArrayElementType m_ElementType;

    public String globalInfo() {
        return "Outputs either a single value (all dimensions in index specified) from an array or a subset (if one or more dimensions left empty).\nOnly arrays of type " + Utils.classToString(Matrix.class) + " are currently supported.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", (Object)new Mat5ArrayElementIndex());
        this.m_OptionManager.add("zero-based-index", "zeroBasedIndex", (Object)false);
        this.m_OptionManager.add("element-type", "elementType", (Object)ArrayElementType.DOUBLE);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"index", (Object)(this.m_Index.isEmpty() ? "-none-" : this.m_Index.getValue()), (String)"index: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"zeroBasedIndex", (Object)(this.m_ZeroBasedIndex ? "0-based" : "1-based"), (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"elementType", (Object)((Object)this.m_ElementType), (String)", element: ");
        return result;
    }

    @Override
    public void setIndex(Mat5ArrayElementIndex value) {
        this.m_Index = value;
        this.reset();
    }

    @Override
    public Mat5ArrayElementIndex getIndex() {
        return this.m_Index;
    }

    @Override
    public String indexTipText() {
        return "The index of the single value (all dimensions specified) or array subset to retrieve (some dimensions left empty).";
    }

    @Override
    public void setZeroBasedIndex(boolean value) {
        this.m_ZeroBasedIndex = value;
        this.reset();
    }

    @Override
    public boolean getZeroBasedIndex() {
        return this.m_ZeroBasedIndex;
    }

    @Override
    public String zeroBasedIndexTipText() {
        return "If true, the index is treated as 0-based (eg 0;0;0 for first value) rather than 1-based ones (eg 1;1;1 for first value).";
    }

    public void setElementType(ArrayElementType value) {
        this.m_ElementType = value;
        this.reset();
    }

    public ArrayElementType getElementType() {
        return this.m_ElementType;
    }

    public String elementTypeTipText() {
        return "Specifies the type of the value being retrieved.";
    }

    public Class[] accepts() {
        return new Class[]{Array.class};
    }

    public Class[] generates() {
        if (this.getOptionManager().hasVariableForProperty("index")) {
            return new Class[]{Unknown.class};
        }
        if (this.m_Index.openDimensions().length > 0) {
            return new Class[]{Array.class};
        }
        return new Class[]{this.m_ElementType.getType()};
    }

    protected String doExecute() {
        String result = null;
        Array array = (Array)this.m_InputToken.getPayload(Array.class);
        int[] index = this.m_Index.indexValue(!this.m_ZeroBasedIndex);
        int[] open = this.m_Index.openDimensions();
        if (!this.m_Index.isCompatible(array)) {
            result = "Different number of dimensions (index != array): " + index.length + " != " + array.getNumDimensions();
        }
        if (result == null && !(array instanceof Matrix)) {
            result = "Array is not of type " + Utils.classToString(Matrix.class) + ", but: " + Utils.classToString((Object)array);
        }
        if (result == null) {
            Matrix source = (Matrix)array;
            if (open.length == 0) {
                this.m_OutputToken = new Token(MatlabUtils.getElement(source, index, this.m_ElementType));
            } else {
                int[] dimsTarget;
                int[] dimsSource = source.getDimensions();
                if (open.length == 1) {
                    int i;
                    int dummyAxis = -1;
                    TIntHashSet set = new TIntHashSet(open);
                    for (i = 0; i < dimsSource.length; ++i) {
                        if (set.contains(i)) continue;
                        dummyAxis = i;
                        set.add(i);
                        open = set.toArray();
                        Arrays.sort(open);
                        break;
                    }
                    dimsTarget = new int[open.length];
                    for (i = 0; i < dimsTarget.length; ++i) {
                        dimsTarget[i] = i == dummyAxis ? 1 : dimsSource[open[i]];
                    }
                } else {
                    dimsTarget = new int[open.length];
                    for (int i = 0; i < dimsTarget.length; ++i) {
                        dimsTarget[i] = dimsSource[open[i]];
                    }
                }
                Matrix target = Mat5.newMatrix((int[])dimsTarget);
                MatlabUtils.transfer(source, dimsSource, open, index, target, dimsTarget, this.m_ElementType);
                this.m_OutputToken = new Token((Object)target);
            }
        }
        return result;
    }
}

