/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatFile;

public class Mat5FileGetArray
extends AbstractTransformer {
    private static final long serialVersionUID = -4381778255320714964L;
    protected String m_EntryName;

    public String globalInfo() {
        return "Retrieves the specified array from the mat file object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("entry-name", "entryName", (Object)"");
    }

    public void setEntryName(String value) {
        this.m_EntryName = value;
        this.reset();
    }

    public String getEntryName() {
        return this.m_EntryName;
    }

    public String entryNameTipText() {
        return "The name of the entry to retrieve, the first one if empty.";
    }

    public Class[] accepts() {
        return new Class[]{Mat5File.class};
    }

    public Class[] generates() {
        return new Class[]{Array.class};
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"entryName", (Object)this.m_EntryName, (String)"entry: ");
    }

    protected String doExecute() {
        if (this.m_EntryName.isEmpty()) {
            this.getLogger().warning("Entry name is empty, returning first entry!");
        }
        String result = null;
        Mat5File mat5 = (Mat5File)this.m_InputToken.getPayload(Mat5File.class);
        for (MatFile.Entry entry : mat5.getEntries()) {
            if (!entry.getName().equals(this.m_EntryName) && !this.m_EntryName.isEmpty()) continue;
            this.m_OutputToken = new Token((Object)entry.getValue());
            break;
        }
        if (this.m_OutputToken == null) {
            this.getLogger().warning("Entry not found: " + this.m_EntryName);
        }
        return result;
    }
}

