/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Struct;

public class Mat5GetStructField
extends AbstractTransformer {
    private static final long serialVersionUID = -1300622968182850650L;
    protected String m_Field;

    public String globalInfo() {
        return "Retrieves the specified struct field.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", (Object)"");
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"field", (Object)(this.m_Field.isEmpty() ? "-none-" : this.m_Field), (String)"field: ");
        return result;
    }

    public void setField(String value) {
        this.m_Field = value;
        this.reset();
    }

    public String getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The name of the field to retrieve.";
    }

    public Class[] accepts() {
        return new Class[]{Struct.class};
    }

    public Class[] generates() {
        return new Class[]{Array.class};
    }

    protected String doExecute() {
        String result = null;
        Struct struct = (Struct)this.m_InputToken.getPayload(Struct.class);
        try {
            this.m_OutputToken = new Token((Object)struct.get(this.m_Field));
        }
        catch (Exception e) {
            result = this.handleException("Failed to retrieve field: " + this.m_Field, e);
        }
        return result;
    }
}

