/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.Mat5ArrayElementIndex;
import adams.core.option.OptionHandler;
import adams.data.matlab.ArrayElementType;
import adams.data.matlab.MatlabArrayIndexSupporter;
import adams.data.matlab.MatlabUtils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Matrix;

public class Mat5SetMatrixElement
extends AbstractTransformer
implements MatlabArrayIndexSupporter {
    private static final long serialVersionUID = -1300622968182850650L;
    protected Mat5ArrayElementIndex m_Index;
    protected boolean m_ZeroBasedIndex;
    protected ArrayElementType m_ElementType;
    protected String m_Value;

    public String globalInfo() {
        return "Sets the specified element in the matrix passing through.\nThe value gets parsed automatically according to the element type.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", (Object)new Mat5ArrayElementIndex());
        this.m_OptionManager.add("zero-based-index", "zeroBasedIndex", (Object)false);
        this.m_OptionManager.add("element-type", "elementType", (Object)ArrayElementType.DOUBLE);
        this.m_OptionManager.add("value", "value", (Object)"");
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"index", (Object)(this.m_Index.isEmpty() ? "-none-" : this.m_Index.getValue()), (String)"index: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"zeroBasedIndex", (Object)(this.m_ZeroBasedIndex ? "0-based" : "1-based"), (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"elementType", (Object)((Object)this.m_ElementType), (String)", element: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)this.m_Value, (String)", value: ");
        return result;
    }

    @Override
    public void setIndex(Mat5ArrayElementIndex value) {
        this.m_Index = value;
        this.reset();
    }

    @Override
    public Mat5ArrayElementIndex getIndex() {
        return this.m_Index;
    }

    @Override
    public String indexTipText() {
        return "The index of the single value to set.";
    }

    @Override
    public void setZeroBasedIndex(boolean value) {
        this.m_ZeroBasedIndex = value;
        this.reset();
    }

    @Override
    public boolean getZeroBasedIndex() {
        return this.m_ZeroBasedIndex;
    }

    @Override
    public String zeroBasedIndexTipText() {
        return "If true, the index is treated as 0-based (eg 0;0;0 for first value) rather than 1-based ones (eg 1;1;1 for first value).";
    }

    public void setElementType(ArrayElementType value) {
        this.m_ElementType = value;
        this.reset();
    }

    public ArrayElementType getElementType() {
        return this.m_ElementType;
    }

    public String elementTypeTipText() {
        return "Specifies the type of the value being set.";
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The value to set in the matrix; gets parsed automatically.";
    }

    public Class[] accepts() {
        return new Class[]{Array.class};
    }

    public Class[] generates() {
        return new Class[]{Array.class};
    }

    protected String doExecute() {
        int[] index;
        Matrix matrix;
        Object result = null;
        Array array = (Array)this.m_InputToken.getPayload(Array.class);
        if (!(array instanceof Matrix)) {
            result = "Input is not of type " + Utils.classToString(Matrix.class) + " but " + Utils.classToString((Object)array) + "!";
        }
        if (this.m_Index.openDimensions().length > 0) {
            result = "Index not fully specified: " + this.m_Index;
        }
        if (result == null && (result = MatlabUtils.setElement(matrix = (Matrix)array, index = this.m_Index.indexValue(!this.m_ZeroBasedIndex), this.m_ElementType, this.m_Value)) == null) {
            this.m_OutputToken = new Token((Object)matrix);
        }
        return result;
    }
}

