/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseClassname;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.core.ObjectRetriever;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Struct;

public class Mat5SetStructField
extends AbstractTransformer {
    private static final long serialVersionUID = -4381778255320714964L;
    protected String m_Field;
    protected ObjectRetriever m_Retriever;

    public String globalInfo() {
        return "Sets obtained array under the specified field name.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("retrieval-type", "retrievalType", (Object)ObjectRetriever.RetrievalType.AUTO);
        this.m_OptionManager.add("object-actor", "objectActor", (Object)new CallableActorReference());
        this.m_OptionManager.add("object-storage", "objectStorage", (Object)new StorageName());
        this.m_OptionManager.add("object-type", "objectType", (Object)new BaseClassname(Object.class));
        this.m_OptionManager.add("field", "field", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_Retriever = new ObjectRetriever();
        this.m_Retriever.setFlowContext((Actor)this);
    }

    public void setRetrievalType(ObjectRetriever.RetrievalType value) {
        this.m_Retriever.setRetrievalType(value);
        this.reset();
    }

    public ObjectRetriever.RetrievalType getRetrievalType() {
        return this.m_Retriever.getRetrievalType();
    }

    public String retrievalTypeTipText() {
        return this.m_Retriever.retrievalTypeTipText();
    }

    public void setObjectActor(CallableActorReference value) {
        this.m_Retriever.setObjectActor(value);
        this.reset();
    }

    public CallableActorReference getObjectActor() {
        return this.m_Retriever.getObjectActor();
    }

    public String objectActorTipText() {
        return this.m_Retriever.objectActorTipText();
    }

    public void setObjectStorage(StorageName value) {
        this.m_Retriever.setObjectStorage(value);
        this.reset();
    }

    public StorageName getObjectStorage() {
        return this.m_Retriever.getObjectStorage();
    }

    public String objectStorageTipText() {
        return this.m_Retriever.objectStorageTipText();
    }

    public void setObjectType(BaseClassname value) {
        this.m_Retriever.setObjectType(value);
        this.reset();
    }

    public BaseClassname getObjectType() {
        return this.m_Retriever.getObjectType();
    }

    public String objectTypeTipText() {
        return this.m_Retriever.objectTypeTipText();
    }

    public void setField(String value) {
        this.m_Field = value;
        this.reset();
    }

    public String getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The field name to use for storing the array.";
    }

    public Class[] accepts() {
        return new Class[]{Struct.class};
    }

    public Class[] generates() {
        return new Class[]{Struct.class};
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"field", (Object)(this.m_Field.isEmpty() ? "-none-" : this.m_Field), (String)"field: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"retrievalType", (Object)this.getRetrievalType(), (String)", type: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"objectSource", (Object)this.getObjectActor(), (String)", source: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"objectStorage", (Object)this.getObjectStorage(), (String)", storage: ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        Struct struct = (Struct)this.m_InputToken.getPayload(Struct.class);
        MessageCollection errors = new MessageCollection();
        Object obj = this.m_Retriever.getObject(errors);
        if (!errors.isEmpty()) {
            result = errors.toString();
        } else {
            try {
                struct.set(this.m_Field, (Array)obj);
                this.m_OutputToken = new Token((Object)struct);
            }
            catch (Exception e) {
                result = this.handleException("Failed to add entry '" + this.m_Field + "'!", e);
            }
        }
        return result;
    }
}

