/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.DataInfoActor;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import us.hebi.matlab.mat.types.Struct;

public class Mat5StructInfo
extends AbstractArrayProvider
implements DataInfoActor {
    private static final long serialVersionUID = 8251699709312918726L;
    protected InfoType m_Type;
    protected boolean m_Sort;

    public String globalInfo() {
        return "Provides information from a Matlab struct object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.NUM_FIELDNAMES);
        this.m_OptionManager.add("sort", "sort", (Object)true);
    }

    public String outputArrayTipText() {
        return "If enabled, outputs the items as array rather than one-by-one.";
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public void setSort(boolean value) {
        this.m_Sort = value;
        this.reset();
    }

    public boolean getSort() {
        return this.m_Sort;
    }

    public String sortTipText() {
        return "If enabled, lists (eg names, values) are sorted.";
    }

    public Class[] accepts() {
        return new Class[]{Struct.class};
    }

    protected Class getItemClass() {
        switch (this.m_Type) {
            case NUM_FIELDNAMES: {
                return Integer.class;
            }
            case FIELD_NAMES: {
                return String.class;
            }
        }
        throw new IllegalStateException("Unhandled info type: " + this.m_Type);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
        HashSet<InfoType> types = new HashSet<InfoType>(Arrays.asList(InfoType.FIELD_NAMES));
        if (types.contains((Object)this.m_Type) || QuickInfoHelper.hasVariable((OptionHandler)this, (String)"type")) {
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"sort", (boolean)this.m_Sort, (String)(this.m_Sort ? "sorted" : "unsorted"), (String)", ");
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        Struct struct = null;
        if (this.m_InputToken.hasPayload(Struct.class)) {
            struct = (Struct)this.m_InputToken.getPayload(Struct.class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (result == null) {
            try {
                this.m_Queue.clear();
                switch (this.m_Type) {
                    case NUM_FIELDNAMES: {
                        this.m_Queue.add(struct.getFieldNames().size());
                        break;
                    }
                    case FIELD_NAMES: {
                        for (String field : struct.getFieldNames()) {
                            this.m_Queue.add(field);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled info type: " + this.m_Type);
                    }
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to generate information: " + this.m_Type, e);
            }
        }
        if (result == null && this.m_Sort && this.m_Queue.size() > 1) {
            Collections.sort(this.m_Queue);
        }
        return result;
    }

    public static enum InfoType {
        NUM_FIELDNAMES,
        FIELD_NAMES;

    }
}

