/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.matlab.multimatrixoperation.AbstractMultiMatrixOperation;
import adams.data.matlab.multimatrixoperation.Add;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Matrix;

public class MultiMat5MatrixOperation
extends AbstractArrayProvider {
    private static final long serialVersionUID = 3690378527551302472L;
    public static final String BACKUP_CURRENTMATRICES = "current matrices";
    protected AbstractMultiMatrixOperation m_Operation;
    protected List<Matrix> m_CurrentMatrices;

    public String globalInfo() {
        return "Applies a multi-matrix operation to the incoming matrix(s) and outputs the generated matrix(s).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("operation", "operation", (Object)new Add());
    }

    protected void initialize() {
        super.initialize();
        this.m_CurrentMatrices = new ArrayList<Matrix>();
    }

    public String outputArrayTipText() {
        return "Whether to output the generated matrices as matrix or one-by-one.";
    }

    public void setOperation(AbstractMultiMatrixOperation value) {
        this.m_Operation = value;
        this.reset();
    }

    public AbstractMultiMatrixOperation getOperation() {
        return this.m_Operation;
    }

    public String operationTipText() {
        return "The operation to apply to the matrices.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"operation", (Object)((Object)this.m_Operation));
    }

    public Class[] accepts() {
        return new Class[]{Array[].class};
    }

    protected Class getItemClass() {
        return Matrix.class;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CURRENTMATRICES);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_CURRENTMATRICES, this.m_CurrentMatrices);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENTMATRICES)) {
            this.m_CurrentMatrices = (List)state.get(BACKUP_CURRENTMATRICES);
            state.remove(BACKUP_CURRENTMATRICES);
        }
        super.restoreState(state);
    }

    protected String doExecute() {
        Object result = null;
        try {
            Array[] input = (Array[])this.m_InputToken.getPayload();
            Matrix[] matrices = new Matrix[input.length];
            for (int i = 0; i < input.length; ++i) {
                if (input[i] instanceof Matrix) {
                    matrices[i] = (Matrix)input[i];
                } else {
                    result = "Array #" + (i + 1) + " is not a " + Utils.classToString(Matrix.class) + "!";
                }
                if (result != null) break;
            }
            if (result == null) {
                this.m_CurrentMatrices = new ArrayList<Matrix>(Arrays.asList(this.m_Operation.process(matrices)));
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to transform matrix(s): ", e);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_CurrentMatrices.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_CurrentMatrices.get(0));
        this.m_CurrentMatrices.remove(0);
        return result;
    }

    public void wrapUp() {
        this.m_CurrentMatrices.clear();
        super.wrapUp();
    }
}

