/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.inspectionhandler;

import adams.data.conversion.Mat5ArrayToSpreadSheet;
import adams.gui.visualization.debug.inspectionhandler.AbstractInspectionHandler;
import java.util.Hashtable;
import nz.ac.waikato.cms.locator.ClassLocator;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Struct;

public class Mat5Array
extends AbstractInspectionHandler {
    public boolean handles(Class cls) {
        return ClassLocator.hasInterface(Array.class, (Class)cls);
    }

    public Hashtable<String, Object> inspect(Object obj) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        Array array = (Array)obj;
        if (array instanceof Struct) {
            Struct struct = (Struct)array;
            for (String field : struct.getFieldNames()) {
                result.put(field, struct.get(field));
            }
        } else if (array.getNumDimensions() <= 2) {
            Mat5ArrayToSpreadSheet conv = new Mat5ArrayToSpreadSheet();
            conv.setInput(array);
            String msg = conv.convert();
            if (msg == null) {
                result.put("data", conv.getOutput());
            }
            conv.cleanUp();
        }
        return result;
    }
}

