/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.maven;

import adams.env.Environment;
import adams.flow.maven.AbstractAdamsMojo;
import adams.flow.maven.shared.FileSystemUtilities;
import java.net.URL;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractJavaGeneratorMojo
extends AbstractAdamsMojo {
    @Parameter(defaultValue="adams.env.Environment", required=true)
    protected String environmentClass;
    @Parameter
    protected String packageName;

    @Override
    protected boolean isReGenerationRequired() {
        return true;
    }

    protected abstract boolean generateCode() throws MojoExecutionException;

    @Override
    protected boolean performExecution() throws MojoExecutionException, MojoFailureException {
        boolean result;
        try {
            FileSystemUtilities.createDirectory(this.getOutputDirectory(), false);
            this.logSystemPropertiesAndBasedir();
            if (Environment.getEnvironmentClass() == null || !Environment.getEnvironmentClass().getClass().getName().equals(this.environmentClass)) {
                Environment.setEnvironmentClass(Class.forName(this.environmentClass));
            }
            result = this.generateCode();
            this.getBuildContext().refresh(this.getOutputDirectory());
            this.addGeneratedSourcesToProjectSourceRoot();
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        return result;
    }

    protected abstract List<URL> getSources();

    protected abstract void addGeneratedSourcesToProjectSourceRoot();
}

