/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.maven;

import adams.flow.maven.shared.FileSystemUtilities;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractAdamsMojo
extends AbstractMojo {
    public static final String NEWLINE = System.getProperty("line.separator");
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution execution;

    protected abstract void addResource(Resource var1);

    protected final BuildContext getBuildContext() {
        return this.getInjectedObject(this.buildContext, "buildContext");
    }

    protected final MavenProject getProject() {
        return this.getInjectedObject(this.project, "project");
    }

    public MojoExecution getExecution() {
        return this.getInjectedObject(this.execution, "execution");
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        boolean isDebugEnabled = log.isDebugEnabled();
        boolean isInfoEnabled = log.isInfoEnabled();
        if (this.shouldExecutionBeSkipped()) {
            if (isDebugEnabled) {
                log.debug((CharSequence)"Skipping execution, as instructed.");
            }
            return;
        }
        if (this.isReGenerationRequired()) {
            if (this.performExecution()) {
                this.buildContext.refresh(this.getOutputDirectory());
            } else if (isInfoEnabled) {
                log.info((CharSequence)"Not updating staleFile timestamp as instructed.");
            }
        } else if (isInfoEnabled) {
            log.info((CharSequence)"No changes detected in schema or binding files - skipping code generation.");
        }
        if (this.getOutputDirectory().exists() && this.getOutputDirectory().isDirectory()) {
            String canonicalPathToOutputDirectory = FileSystemUtilities.getCanonicalPath(this.getOutputDirectory());
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Adding existing code outputDirectory [" + canonicalPathToOutputDirectory + "] to Maven's sources."));
            }
            this.getProject().addCompileSourceRoot(canonicalPathToOutputDirectory);
        }
    }

    protected abstract boolean shouldExecutionBeSkipped();

    protected abstract boolean isReGenerationRequired();

    protected abstract boolean performExecution() throws MojoExecutionException, MojoFailureException;

    protected abstract File getOutputDirectory();

    protected List<String> getClasspath() throws MojoExecutionException {
        try {
            return this.getProject().getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not retrieve Compile classpath.", (Exception)((Object)e));
        }
    }

    protected void warnAboutIncorrectPluginConfiguration(String propertyName, String description) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n+=================== [Incorrect Plugin Configuration Detected]\n");
        builder.append("|\n");
        builder.append("| Property : " + propertyName + "\n");
        builder.append("| Problem  : " + description + "\n");
        builder.append("|\n");
        builder.append("+=================== [End Incorrect Plugin Configuration Detected]\n\n");
        this.getLog().warn((CharSequence)builder.toString().replace("\n", NEWLINE));
    }

    private <T> T getInjectedObject(T objectOrNull, String objectName) {
        if (objectOrNull == null) {
            this.getLog().error((CharSequence)("Found null '" + objectName + "', implying that Maven @Component injection was not done properly."));
        }
        return objectOrNull;
    }

    protected void logSystemPropertiesAndBasedir() {
        if (this.getLog().isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("\n+=================== [System properties]\n");
            builder.append("|\n");
            TreeMap<String, Object> props = new TreeMap<String, Object>();
            props.put("basedir", FileSystemUtilities.getCanonicalPath(this.getProject().getBasedir()));
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                props.put("" + entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                builder.append("| [" + (String)entry.getKey() + "]: " + entry.getValue() + "\n");
            }
            builder.append("|\n");
            builder.append("+=================== [End System properties]\n");
            this.getLog().debug((CharSequence)builder.toString().replace("\n", NEWLINE));
        }
    }
}

