/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.maven;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.management.Java;
import adams.core.management.ProcessUtils;
import adams.core.option.ApplyActorProducer;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.maven.AbstractJavaGeneratorMojo;
import adams.flow.maven.shared.FileSystemUtilities;
import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="apply", threadSafe=true, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ApplyActorMojo
extends AbstractJavaGeneratorMojo {
    @Parameter(defaultValue="", required=true)
    private String simpleName;
    @Parameter(defaultValue=".", required=true)
    private File flow;
    @Parameter(defaultValue="adams.core.option.CompactFlowConsumer", required=true)
    private String flowFormat;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/apply", required=true)
    private File outputDirectory;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;

    @Override
    protected boolean shouldExecutionBeSkipped() {
        return this.skip;
    }

    protected File classOutputDir() {
        return new File(this.getOutputDirectory().getAbsolutePath() + "/" + this.packageName.replace(".", "/"));
    }

    protected File classOutputFile() {
        return new File(this.classOutputDir().getAbsolutePath() + "/" + this.simpleName + ".java");
    }

    @Override
    protected boolean generateCode() throws MojoExecutionException {
        MessageCollection errors = new MessageCollection();
        MessageCollection warnings = new MessageCollection();
        Actor actor = ActorUtils.read((String)this.flow.getAbsolutePath(), (MessageCollection)errors, (MessageCollection)warnings);
        if (!warnings.isEmpty()) {
            this.getLog().warn((CharSequence)("Warnings encountered loading flow '" + this.flow + "':\n" + warnings.toString()));
        }
        if (actor == null) {
            if (errors.isEmpty()) {
                throw new MojoExecutionException("Failed to load flow '" + this.flow + "'!");
            }
            throw new MojoExecutionException("Failed to load flow '" + this.flow + "':\n" + errors.toString());
        }
        File outputDir = this.classOutputDir();
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new MojoExecutionException("Failed to create output directory: " + outputDir);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(Java.getJavaExecutable());
        cmd.add("-classpath");
        cmd.add(Utils.flatten(this.getClasspath(), (String)System.getProperty("path.separator")));
        cmd.add(ApplyActorProducer.class.getName());
        cmd.add("-env");
        cmd.add(this.environmentClass);
        cmd.add("-input");
        cmd.add(this.flow.getAbsolutePath());
        cmd.add("-format");
        cmd.add(this.flowFormat);
        cmd.add("-package");
        cmd.add(this.packageName);
        cmd.add("-simple-name");
        cmd.add(this.simpleName);
        cmd.add("-output");
        cmd.add(this.classOutputFile().getAbsolutePath());
        this.getLog().debug((CharSequence)("Executing: " + Utils.flatten(cmd, (String)" ")));
        try {
            CollectingProcessOutput output = ProcessUtils.execute((String[])cmd.toArray(new String[0]));
            if (output.getExitCode() != 0) {
                if (!output.getStdErr().isEmpty()) {
                    this.getLog().error((CharSequence)output.getStdErr());
                }
                throw new Exception("Code generation failed with exit code: " + output.getExitCode());
            }
            this.getLog().info((CharSequence)output.getStdOut());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute command: " + Utils.flatten(cmd, (String)" "), e);
        }
        return true;
    }

    @Override
    protected void addResource(Resource resource) {
        this.getProject().addResource(resource);
    }

    @Override
    protected List<URL> getSources() {
        ArrayList<URL> result = new ArrayList<URL>();
        try {
            result.add(this.classOutputFile().toURL());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Failed to generate URL from output file: " + this.classOutputFile()), (Throwable)e);
        }
        return result;
    }

    @Override
    protected void addGeneratedSourcesToProjectSourceRoot() {
        this.getProject().addCompileSourceRoot(FileSystemUtilities.getCanonicalPath(this.getOutputDirectory()));
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }
}

