/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.maven;

import adams.core.ClassLister;
import adams.core.Utils;
import adams.core.management.Java;
import adams.core.management.ProcessUtils;
import adams.flow.maven.AbstractAdamsMojo;
import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="classlister", threadSafe=false, defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ClassListerMojo
extends AbstractAdamsMojo {
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project.build.directory}/classes", required=true)
    private File outputDirectory;

    @Override
    protected boolean shouldExecutionBeSkipped() {
        return this.skip;
    }

    @Override
    protected void addResource(Resource resource) {
        this.getProject().addResource(resource);
    }

    @Override
    protected boolean isReGenerationRequired() {
        return true;
    }

    protected void execute(List<String> cmd) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Executing: " + Utils.flatten(cmd, (String)" ")));
        try {
            CollectingProcessOutput output = ProcessUtils.execute((String[])cmd.toArray(new String[0]));
            if (output.getExitCode() != 0) {
                if (!output.getStdErr().isEmpty()) {
                    this.getLog().error((CharSequence)output.getStdErr());
                }
                throw new Exception("Code generation failed with exit code: " + output.getExitCode());
            }
            this.getLog().info((CharSequence)output.getStdOut());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute command: " + Utils.flatten(cmd, (String)" "), e);
        }
    }

    @Override
    protected boolean performExecution() throws MojoExecutionException, MojoFailureException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(Java.getJavaExecutable());
        cmd.add("-classpath");
        cmd.add(Utils.flatten(this.getClasspath(), (String)System.getProperty("path.separator")));
        cmd.add(ClassLister.class.getName());
        cmd.add("-action");
        cmd.add("classes");
        cmd.add("-output");
        cmd.add(this.outputDirectory.getAbsolutePath() + File.separator + "ClassLister.classes");
        this.execute(cmd);
        cmd = new ArrayList();
        cmd.add(Java.getJavaExecutable());
        cmd.add("-classpath");
        cmd.add(Utils.flatten(this.getClasspath(), (String)System.getProperty("path.separator")));
        cmd.add(ClassLister.class.getName());
        cmd.add("-action");
        cmd.add("packages");
        cmd.add("-output");
        cmd.add(this.outputDirectory.getAbsolutePath() + File.separator + "ClassLister.packages");
        this.execute(cmd);
        return true;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }
}

