/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.maven.shared;

import adams.flow.maven.shared.Validate;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;

public final class FileSystemUtilities {
    public static final FileFilter EXISTING_FILE = new FileFilter(){

        @Override
        public boolean accept(File candidate) {
            return candidate != null && candidate.exists() && candidate.isFile();
        }
    };
    public static final FileFilter EXISTING_DIRECTORY = new FileFilter(){

        @Override
        public boolean accept(File candidate) {
            return candidate != null && candidate.exists() && candidate.isDirectory();
        }
    };
    private static final String[] INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME = new String[]{":", "*", "?", "\"", "<", ">", "|"};

    private FileSystemUtilities() {
    }

    public static String getCanonicalPath(File file) {
        return FileSystemUtilities.getCanonicalFile(file).getPath();
    }

    public static File getCanonicalFile(File file) {
        Validate.notNull(file, "file");
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not acquire the canonical file for [" + file.getAbsolutePath() + "]", e);
        }
    }

    public static File getExistingFile(String path, File baseDir) {
        Validate.notEmpty(path, "path");
        File theFile = new File(path);
        File toReturn = null;
        if (theFile.isAbsolute() && (EXISTING_FILE.accept(theFile) || EXISTING_DIRECTORY.accept(theFile))) {
            toReturn = FileSystemUtilities.getCanonicalFile(theFile);
        }
        if (!theFile.isAbsolute()) {
            Validate.notNull(baseDir, "baseDir");
            File relativeFile = new File(baseDir, path);
            if (EXISTING_FILE.accept(relativeFile) || EXISTING_DIRECTORY.accept(relativeFile)) {
                toReturn = FileSystemUtilities.getCanonicalFile(relativeFile);
            }
        }
        return toReturn;
    }

    public static URL getUrlFor(File aFile) throws IllegalArgumentException {
        Validate.notNull(aFile, "aFile");
        try {
            return aFile.toURI().normalize().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not retrieve the URL from file [" + FileSystemUtilities.getCanonicalPath(aFile) + "]", e);
        }
    }

    public static File getFileFor(URL anURL, String encoding) {
        Validate.notNull(anURL, "anURL");
        Validate.notNull(encoding, "encoding");
        String protocol = anURL.getProtocol();
        File toReturn = null;
        if ("file".equalsIgnoreCase(protocol)) {
            try {
                String decodedPath = URLDecoder.decode(anURL.getPath(), encoding);
                toReturn = new File(decodedPath);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not get the File for [" + anURL + "]", e);
            }
        }
        if ("jar".equalsIgnoreCase(protocol)) {
            try {
                String tmp = URLDecoder.decode(anURL.getFile(), encoding);
                URL innerURL = new URL(tmp);
                if ("file".equalsIgnoreCase(innerURL.getProtocol())) {
                    String innerUrlPath = innerURL.getPath();
                    String filePath = innerUrlPath.contains("!") ? innerUrlPath.substring(0, innerUrlPath.indexOf("!")) : innerUrlPath;
                    toReturn = new File(URLDecoder.decode(filePath, encoding));
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not get the File for [" + anURL + "]", e);
            }
        }
        return toReturn;
    }

    public static void createDirectory(File aDirectory, boolean cleanBeforeCreate) throws MojoExecutionException {
        boolean existsAsFile;
        Validate.notNull(aDirectory, "aDirectory");
        FileSystemUtilities.validateFileOrDirectoryName(aDirectory);
        if (cleanBeforeCreate) {
            try {
                FileUtils.deleteDirectory((File)aDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not clean directory [" + FileSystemUtilities.getCanonicalPath(aDirectory) + "]", (Exception)e);
            }
        }
        boolean bl = existsAsFile = aDirectory.exists() && aDirectory.isFile();
        if (existsAsFile) {
            throw new MojoExecutionException("[" + FileSystemUtilities.getCanonicalPath(aDirectory) + "] exists and is a file. Cannot make directory");
        }
        if (!aDirectory.exists() && !aDirectory.mkdirs()) {
            throw new MojoExecutionException("Could not create directory [" + FileSystemUtilities.getCanonicalPath(aDirectory) + "]");
        }
    }

    private static void validateFileOrDirectoryName(File fileOrDir) {
        if (Os.isFamily((String)"windows") && !FileUtils.isValidWindowsFileName((File)fileOrDir)) {
            throw new IllegalArgumentException("The file (" + fileOrDir + ") cannot contain any of the following characters: \n" + StringUtils.join((Object[])INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME, (String)" "));
        }
    }
}

