/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.MekaDatasetHelper;
import adams.flow.core.Token;
import adams.flow.source.MekaClassifierSetup;
import adams.flow.transformer.AbstractTransformer;
import meka.classifiers.multilabel.MultiLabelClassifier;
import nz.ac.waikato.adams.webservice.meka.CrossValidateClassifier;
import nz.ac.waikato.adams.webservice.meka.Dataset;
import weka.core.Instances;

public class MekaWSCrossValidationClassifier
extends AbstractTransformer {
    private static final long serialVersionUID = -1600923751846355040L;
    protected int m_Seed;
    protected int m_Folds;
    protected MultiLabelClassifier m_Classifier;
    protected CallableActorReference m_ClassifierActor;

    public String globalInfo() {
        return "Performs cross-validation of a classifier on a dataset, using the Meka web-service.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new CallableActorReference(MekaClassifierSetup.class.getSimpleName()));
        this.m_OptionManager.add("folds", "folds", (Object)10, (Number)2, null);
        this.m_OptionManager.add("seed", "seed", (Object)1);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"classifier", (Object)this.m_Classifier, (String)"classifier: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"folds", (Object)this.m_Folds, (String)", folds: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"seed", (Object)this.m_Seed, (String)", seed: ");
        return result;
    }

    public void setFolds(int f) {
        if (f >= 2) {
            this.m_Folds = f;
            this.reset();
        } else {
            this.getLogger().severe("At least 2 folds required, provided: " + f);
        }
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "number of folds for the cross validation";
    }

    public void setSeed(int s) {
        this.m_Seed = s;
        this.reset();
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "seed for the cross validation";
    }

    public void setClassifier(CallableActorReference c) {
        this.m_ClassifierActor = c;
        this.reset();
    }

    public CallableActorReference getClassifier() {
        return this.m_ClassifierActor;
    }

    public String classifierTipText() {
        return "Global actore for the classifier to use for cross validation";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{CrossValidateClassifier.class};
    }

    protected String doExecute() {
        CrossValidateClassifier cV = new CrossValidateClassifier();
        this.m_Classifier = this.getClassifierInstance();
        cV.setClassifier(OptionUtils.getCommandLine((Object)this.m_Classifier));
        Dataset d = MekaDatasetHelper.fromInstances((Instances)this.m_InputToken.getPayload());
        cV.setDataset(d);
        cV.setSeed(this.m_Seed);
        cV.setFolds(this.m_Folds);
        this.m_OutputToken = new Token((Object)cV);
        return null;
    }

    protected MultiLabelClassifier getClassifierInstance() {
        MessageCollection errors = new MessageCollection();
        MultiLabelClassifier result = (MultiLabelClassifier)CallableActorHelper.getSetup(MultiLabelClassifier.class, (CallableActorReference)this.m_ClassifierActor, (Actor)this, (MessageCollection)errors);
        if (result == null && !errors.isEmpty()) {
            this.getLogger().severe(errors.toString());
        }
        return result;
    }
}

