/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.meka;

import adams.flow.core.Actor;
import adams.flow.webservice.AbstractWebServiceClientTransformer;
import adams.flow.webservice.WebserviceUtils;
import adams.flow.webservice.interceptor.incoming.AbstractInInterceptorGenerator;
import adams.flow.webservice.interceptor.outgoing.AbstractOutInterceptorGenerator;
import java.net.URL;
import javax.xml.ws.BindingProvider;
import nz.ac.waikato.adams.webservice.meka.Dataset;
import nz.ac.waikato.adams.webservice.meka.MekaService;
import nz.ac.waikato.adams.webservice.meka.MekaServiceService;
import nz.ac.waikato.adams.webservice.meka.TransformResponseObject;

public class Transform
extends AbstractWebServiceClientTransformer<nz.ac.waikato.adams.webservice.meka.Transform, Dataset> {
    private static final long serialVersionUID = -338043583699608760L;
    protected nz.ac.waikato.adams.webservice.meka.Transform m_Transform;

    public String globalInfo() {
        return "transforms a dataset using the meka web service";
    }

    public Class[] accepts() {
        return new Class[]{nz.ac.waikato.adams.webservice.meka.Transform.class};
    }

    public Class[] generates() {
        return new Class[]{Dataset.class};
    }

    public URL getWsdlLocation() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource("wsdl/meka/MekaService.wsdl");
    }

    public void setRequestData(nz.ac.waikato.adams.webservice.meka.Transform value) {
        this.m_Transform = value;
    }

    protected void doQuery() throws Exception {
        MekaServiceService mekaServiceService = new MekaServiceService(this.getWsdlLocation());
        MekaService mekaService = mekaServiceService.getMekaServicePort();
        WebserviceUtils.configureClient((Actor)this.m_Owner, (Object)mekaService, (int)this.m_ConnectionTimeout, (int)this.m_ReceiveTimeout, (String)(this.getUseAlternativeURL() ? this.getAlternativeURL() : null), (AbstractInInterceptorGenerator)this.m_InInterceptor, (AbstractOutInterceptorGenerator)this.m_OutInterceptor);
        WebserviceUtils.enableSchemaValidation((BindingProvider)((BindingProvider)mekaService));
        TransformResponseObject returned = mekaService.transform(this.m_Transform.getDataset(), this.m_Transform.getActorName());
        if (returned.getErrorMessage() != null) {
            throw new IllegalStateException(returned.getErrorMessage());
        }
        this.setResponseData(returned.getReturnDataset());
        this.m_Transform = null;
    }
}

