/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.meka;

import adams.flow.core.Actor;
import adams.flow.webservice.AbstractWebServiceClientTransformer;
import adams.flow.webservice.WebserviceUtils;
import adams.flow.webservice.interceptor.incoming.AbstractInInterceptorGenerator;
import adams.flow.webservice.interceptor.outgoing.AbstractOutInterceptorGenerator;
import java.net.URL;
import javax.xml.ws.BindingProvider;
import nz.ac.waikato.adams.webservice.meka.CrossValidateClassifier;
import nz.ac.waikato.adams.webservice.meka.CrossValidateResponseObject;
import nz.ac.waikato.adams.webservice.meka.Dataset;
import nz.ac.waikato.adams.webservice.meka.MekaService;
import nz.ac.waikato.adams.webservice.meka.MekaServiceService;

public class CrossValidationClassifier
extends AbstractWebServiceClientTransformer<CrossValidateClassifier, Dataset> {
    private static final long serialVersionUID = -3627934949295336741L;
    protected CrossValidateClassifier m_CrossValidate;

    public String globalInfo() {
        return "Triggers a cross-validation on the server.";
    }

    public Class[] accepts() {
        return new Class[]{CrossValidateClassifier.class};
    }

    public void setRequestData(CrossValidateClassifier value) {
        this.m_CrossValidate = value;
    }

    public Class[] generates() {
        return new Class[]{Dataset.class};
    }

    public URL getWsdlLocation() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource("wsdl/meka/MekaService.wsdl");
    }

    protected void doQuery() throws Exception {
        MekaServiceService mekaServiceService = new MekaServiceService(this.getWsdlLocation());
        MekaService mekaService = mekaServiceService.getMekaServicePort();
        WebserviceUtils.configureClient((Actor)this.m_Owner, (Object)mekaService, (int)this.m_ConnectionTimeout, (int)this.m_ReceiveTimeout, (String)(this.getUseAlternativeURL() ? this.getAlternativeURL() : null), (AbstractInInterceptorGenerator)this.m_InInterceptor, (AbstractOutInterceptorGenerator)this.m_OutInterceptor);
        WebserviceUtils.enableSchemaValidation((BindingProvider)((BindingProvider)mekaService));
        CrossValidateResponseObject returned = mekaService.crossValidateClassifier(this.m_CrossValidate.getDataset(), this.m_CrossValidate.getSeed(), this.m_CrossValidate.getFolds(), this.m_CrossValidate.getClassifier());
        if (returned.getErrorMessage() != null) {
            throw new IllegalStateException(returned.getErrorMessage());
        }
        this.setResponseData(returned.getReturnDataset());
        this.m_CrossValidate = null;
    }
}

