/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.meka;

import adams.core.SerializationHelper;
import adams.core.Utils;
import adams.core.logging.LoggingSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.LookUpHelper;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Compatibility;
import adams.flow.core.InputConsumer;
import adams.flow.core.MekaDatasetHelper;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.webservice.meka.MekaServiceWS;
import adams.flow.webservice.meka.OwnedByMekaServiceWS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import meka.classifiers.MultiXClassifier;
import meka.classifiers.multilabel.Evaluation;
import meka.classifiers.multilabel.MultiLabelClassifier;
import meka.core.MLUtils;
import meka.core.Result;
import nz.ac.waikato.adams.webservice.meka.Attributes;
import nz.ac.waikato.adams.webservice.meka.Body;
import nz.ac.waikato.adams.webservice.meka.CrossValidateResponseObject;
import nz.ac.waikato.adams.webservice.meka.Dataset;
import nz.ac.waikato.adams.webservice.meka.DisplayClassifierResponseObject;
import nz.ac.waikato.adams.webservice.meka.DownloadClassifierResponseObject;
import nz.ac.waikato.adams.webservice.meka.Header;
import nz.ac.waikato.adams.webservice.meka.Instance;
import nz.ac.waikato.adams.webservice.meka.InstanceType;
import nz.ac.waikato.adams.webservice.meka.Instances;
import nz.ac.waikato.adams.webservice.meka.MekaService;
import nz.ac.waikato.adams.webservice.meka.PredictClassifierResponseObject;
import nz.ac.waikato.adams.webservice.meka.TestClassifierResponseObject;
import nz.ac.waikato.adams.webservice.meka.TrainClassifierResponseObject;
import nz.ac.waikato.adams.webservice.meka.TransformResponseObject;
import nz.ac.waikato.adams.webservice.meka.Type;

public class SimpleMekaService
extends AbstractOptionHandler
implements MekaService,
OwnedByMekaServiceWS {
    private static final long serialVersionUID = -6102580694812360595L;
    protected MekaServiceWS m_Owner;
    protected StorageName m_StorageName;

    public SimpleMekaService() {
        this.setOwner(null);
    }

    public String globalInfo() {
        return "Simple implementation of a WEKA webservice. Not multi-threaded.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("lookup"));
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name for the lookup table in the internal storage.";
    }

    @Override
    public void setOwner(MekaServiceWS value) {
        this.m_Owner = value;
        if (this.m_Owner != null && this.m_Owner.getFlowContext() != null && !this.m_Owner.getFlowContext().getStorageHandler().getStorage().has(this.m_StorageName)) {
            throw new IllegalStateException("Lookup table for models not available: " + this.m_StorageName);
        }
    }

    @Override
    public MekaServiceWS getOwner() {
        return this.m_Owner;
    }

    protected void store(String name, MultiLabelClassifier cls) {
        HashMap table = LookUpHelper.getTable((Actor)this.m_Owner.getFlowContext(), (StorageName)this.m_StorageName);
        table.put(name, cls);
    }

    protected MultiLabelClassifier retrieve(String name) {
        HashMap table = LookUpHelper.getTable((Actor)this.m_Owner.getFlowContext(), (StorageName)this.m_StorageName);
        return (MultiLabelClassifier)table.get(name);
    }

    @Override
    public TrainClassifierResponseObject trainClassifier(Dataset dataset, String classifier, String name) {
        TrainClassifierResponseObject result = new TrainClassifierResponseObject();
        this.m_Owner.getLogger().info("training classifier");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info(classifier);
        this.m_Owner.getLogger().info(name);
        try {
            weka.core.Instances data = MekaDatasetHelper.toInstances(dataset);
            MultiLabelClassifier cls = (MultiLabelClassifier)OptionUtils.forAnyCommandLine(MultiLabelClassifier.class, (String)classifier);
            cls.buildClassifier(data);
            this.store(name, cls);
            result.setModel(cls.toString());
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this.m_Owner, (String)("Failed to train classifier: " + classifier), (Throwable)ex));
        }
        return result;
    }

    @Override
    public TestClassifierResponseObject testClassifier(Dataset dataset, String modelName) {
        TestClassifierResponseObject result = new TestClassifierResponseObject();
        this.m_Owner.getLogger().info("testing classifier");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info(modelName);
        MultiLabelClassifier cls = this.retrieve(modelName);
        if (cls == null) {
            result.setErrorMessage("Failed to test model '" + modelName + "', as it is not available from storage!");
            return result;
        }
        try {
            weka.core.Instances data = MekaDatasetHelper.toInstances(dataset);
            Result res = Evaluation.evaluateModel((MultiXClassifier)cls, (weka.core.Instances)data, (String)"0.0", (String)"3");
            result.setReturnDataset(MekaDatasetHelper.evaluationToDataset(res));
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this.m_Owner, (String)("Failed to test model '" + modelName + "'!"), (Throwable)ex));
        }
        return result;
    }

    @Override
    public CrossValidateResponseObject crossValidateClassifier(Dataset dataset, int seed, int folds, String classifier) {
        CrossValidateResponseObject result = new CrossValidateResponseObject();
        this.m_Owner.getLogger().info("cross-validation");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info("" + seed);
        this.m_Owner.getLogger().info("" + folds);
        this.m_Owner.getLogger().info(classifier);
        try {
            weka.core.Instances data = MekaDatasetHelper.toInstances(dataset);
            data.randomize(new Random(seed));
            MultiLabelClassifier cls = (MultiLabelClassifier)OptionUtils.forAnyCommandLine(MultiLabelClassifier.class, (String)classifier);
            Result res = Evaluation.cvModel((MultiLabelClassifier)cls, (weka.core.Instances)data, (int)folds, (String)"PCut1", (String)"3");
            result.setReturnDataset(MekaDatasetHelper.evaluationToDataset(res));
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this.m_Owner, (String)("Failed to cross-validate classifier '" + classifier + "'!"), (Throwable)ex));
        }
        return result;
    }

    @Override
    public PredictClassifierResponseObject predictClassifier(Dataset dataset, String modelName) {
        PredictClassifierResponseObject result = new PredictClassifierResponseObject();
        this.m_Owner.getLogger().info("predicting using classifier");
        this.displayString(dataset);
        this.m_Owner.getLogger().info(dataset.toString());
        this.m_Owner.getLogger().info(modelName);
        MultiLabelClassifier cls = this.retrieve(modelName);
        if (cls == null) {
            result.setErrorMessage("Failed to make predictions using classifier model '" + modelName + "', as it is not available from storage!");
            return result;
        }
        weka.core.Instances data = MekaDatasetHelper.toInstances(dataset);
        try {
            int i;
            MLUtils.prepareData((weka.core.Instances)data);
            Dataset pred = new Dataset();
            result.setReturnDataset(pred);
            pred.setName("Predictions on '" + data.relationName() + "' using '" + modelName + "'");
            pred.setVersion(MekaDatasetHelper.getDateFormat().format(new Date()));
            pred.setHeader(new Header());
            pred.getHeader().setAttributes(new Attributes());
            for (i = 0; i < data.classIndex(); ++i) {
                MekaDatasetHelper.addAttribute(pred, "Distribution (" + data.attribute(i).name() + ")", Type.NUMERIC);
            }
            pred.setBody(new Body());
            pred.getBody().setInstances(new Instances());
            for (i = 0; i < data.numInstances(); ++i) {
                weka.core.Instance inst = data.instance(i);
                inst.setClassMissing();
                Instance in = new Instance();
                in.setInstanceType(InstanceType.NORMAL);
                in.setInstanceWeight(1.0);
                pred.getBody().getInstances().getInstance().add(in);
                double[] distribution = cls.distributionForInstance(inst);
                for (int n = 0; n < distribution.length; ++n) {
                    MekaDatasetHelper.addValue(in, n, distribution[n]);
                }
            }
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this.m_Owner, (String)("Failed to make predictions with classifier model '" + modelName + "'!"), (Throwable)ex));
        }
        return result;
    }

    @Override
    public DownloadClassifierResponseObject downloadClassifier(String modelName) {
        DownloadClassifierResponseObject result = new DownloadClassifierResponseObject();
        this.m_Owner.getLogger().info("downloading classifier");
        this.m_Owner.getLogger().info(modelName);
        MultiLabelClassifier cls = this.retrieve(modelName);
        if (cls == null) {
            result.setErrorMessage("No Classifier available named: " + modelName);
            return result;
        }
        try {
            result.setModelData(new DataHandler((DataSource)new ByteArrayDataSource(SerializationHelper.toByteArray((Object)cls), "application/octet-stream")));
        }
        catch (Exception e) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this, (String)("Failed to serialize classifier: " + modelName), (Throwable)e));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransformResponseObject transform(Dataset dataset, String actorName) {
        TransformResponseObject result = new TransformResponseObject();
        this.m_Owner.getLogger().info("transform");
        CallableActorHelper helper = new CallableActorHelper();
        Actor callable = helper.findCallableActor(this.m_Owner.getFlowContext().getRoot(), new CallableActorReference(actorName));
        if (callable == null) {
            result.setErrorMessage("Failed to find callable actor '" + actorName + "'!");
            return result;
        }
        if (!ActorUtils.isTransformer((Actor)callable)) {
            result.setErrorMessage("Callable actor '" + actorName + "' is not a transformer!");
            return result;
        }
        Compatibility comp = new Compatibility();
        if (!comp.isCompatible(new Class[]{weka.core.Instances.class}, ((InputConsumer)callable).accepts())) {
            result.setErrorMessage("Callable transformer '" + actorName + "' does not accept " + weka.core.Instances.class.getName() + "!");
            return result;
        }
        if (!comp.isCompatible(((OutputProducer)callable).generates(), new Class[]{weka.core.Instances.class})) {
            result.setErrorMessage("Callable transformer '" + actorName + "' does not generate " + weka.core.Instances.class.getName() + "!");
            return result;
        }
        weka.core.Instances data = MekaDatasetHelper.toInstances(dataset);
        try {
            Actor actor = callable;
            synchronized (actor) {
                ((InputConsumer)callable).input(new Token((Object)data));
                String msg = callable.execute();
                if (msg != null) {
                    result.setErrorMessage(msg);
                    return result;
                }
                if (!((OutputProducer)callable).hasPendingOutput()) {
                    result.setErrorMessage("Callable transformer '" + actorName + "' did not produce any output!");
                    return result;
                }
                Token output = ((OutputProducer)callable).output();
                data = (weka.core.Instances)output.getPayload();
                result.setReturnDataset(MekaDatasetHelper.fromInstances(data));
            }
        }
        catch (Exception ex) {
            result.setErrorMessage(Utils.handleException((LoggingSupporter)this.m_Owner, (String)("Failed to transform data using callable transformer '" + actorName + "'!"), (Throwable)ex));
        }
        return result;
    }

    @Override
    public DisplayClassifierResponseObject displayClassifier(String model) {
        this.m_Owner.getLogger().info("displaying classifier: " + model);
        DisplayClassifierResponseObject result = new DisplayClassifierResponseObject();
        MultiLabelClassifier cls = this.retrieve(model);
        if (cls != null) {
            result.setDisplayString(cls.getModel());
        } else {
            result.setErrorMessage("Classifier model '" + model + "' not available from storage!");
        }
        return result;
    }

    @Override
    public List<String> listClassifiers() {
        this.m_Owner.getLogger().info("listing classifiers");
        HashMap table = LookUpHelper.getTable((Actor)this.m_Owner.getFlowContext(), (StorageName)this.m_StorageName);
        ArrayList<String> result = new ArrayList<String>(table.keySet());
        Collections.sort(result);
        if (this.m_Owner.isLoggingEnabled()) {
            this.m_Owner.getLogger().info("current classifiers" + result);
        }
        return result;
    }

    protected void displayString(Dataset dataset) {
        if (!this.m_Owner.isLoggingEnabled()) {
            return;
        }
        this.m_Owner.getLogger().info("Number of instances: \t " + dataset.getBody().getInstances().getInstance().size());
        this.m_Owner.getLogger().info(MekaDatasetHelper.datasetToString(dataset));
    }
}

