/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.DateFormat;
import adams.core.DateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import meka.core.Result;
import nz.ac.waikato.adams.webservice.meka.Attributes;
import nz.ac.waikato.adams.webservice.meka.Body;
import nz.ac.waikato.adams.webservice.meka.Dataset;
import nz.ac.waikato.adams.webservice.meka.Header;
import nz.ac.waikato.adams.webservice.meka.Instance;
import nz.ac.waikato.adams.webservice.meka.InstanceType;
import nz.ac.waikato.adams.webservice.meka.Labels;
import nz.ac.waikato.adams.webservice.meka.Type;
import nz.ac.waikato.adams.webservice.meka.Value;
import nz.ac.waikato.adams.webservice.meka.YesNo;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.Version;

public class MekaDatasetHelper {
    protected static DateFormat m_DateFormat = DateUtils.getTimestampFormatterMsecs();

    public static Dataset fromInstances(Instances inst) {
        Dataset xrffDataset = new Dataset();
        Header header = new Header();
        Body body = new Body();
        xrffDataset.setBody(body);
        xrffDataset.setHeader(header);
        xrffDataset.setName(inst.relationName());
        xrffDataset.setVersion(Version.VERSION);
        Attributes attributes = new Attributes();
        header.setAttributes(attributes);
        int classIndex = inst.classIndex();
        for (int i = 0; i < inst.numAttributes(); ++i) {
            nz.ac.waikato.adams.webservice.meka.Attribute attribute = new nz.ac.waikato.adams.webservice.meka.Attribute();
            Attribute mekaAttribute = inst.attribute(i);
            attribute.setName(mekaAttribute.name());
            Type type = Type.STRING;
            switch (mekaAttribute.type()) {
                case 1: {
                    type = Type.NOMINAL;
                    Labels l = new Labels();
                    attribute.setLabels(l);
                    Enumeration enm = mekaAttribute.enumerateValues();
                    while (enm.hasMoreElements()) {
                        l.getLabel().add((String)enm.nextElement());
                    }
                    break;
                }
                case 0: {
                    type = Type.NUMERIC;
                    break;
                }
                case 3: {
                    type = Type.DATE;
                    attribute.setFormat(mekaAttribute.getDateFormat());
                    break;
                }
                case 2: {
                    type = Type.STRING;
                    break;
                }
                case 4: {
                    type = Type.RELATIONAL;
                }
            }
            attribute.setType(type);
            if (i == classIndex) {
                attribute.setClassAttribute(YesNo.YES);
            }
            attribute.setWeight(mekaAttribute.weight());
            attributes.getAttribute().add(attribute);
        }
        nz.ac.waikato.adams.webservice.meka.Instances instances = new nz.ac.waikato.adams.webservice.meka.Instances();
        body.setInstances(instances);
        for (int i = 0; i < inst.size(); ++i) {
            weka.core.Instance mekaInstance = inst.get(i);
            Instance instanceToAdd = new Instance();
            instanceToAdd.setInstanceWeight(mekaInstance.weight());
            boolean isSparse = mekaInstance instanceof SparseInstance;
            instanceToAdd.setInstanceType(InstanceType.NORMAL);
            if (isSparse) {
                instanceToAdd.setInstanceType(InstanceType.SPARSE);
            }
            for (int v = 0; v < mekaInstance.numValues(); ++v) {
                String attributeValue;
                Value value = new Value();
                int index = mekaInstance.index(v);
                if (mekaInstance.attribute(index).isNumeric()) {
                    Double val = mekaInstance.value(index);
                    attributeValue = val.toString();
                } else {
                    attributeValue = mekaInstance.stringValue(index);
                }
                if (attributeValue != null) {
                    value.setValue(attributeValue);
                } else {
                    value.setValueMissing(YesNo.YES);
                }
                if (isSparse) {
                    value.setValueIndex(index);
                }
                instanceToAdd.getValue().add(value);
            }
            instances.getInstance().add(instanceToAdd);
        }
        return xrffDataset;
    }

    public static Instances toInstances(Dataset d) {
        int n;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int classIndex = -1;
        block15: for (n = 0; n < d.getHeader().getAttributes().getAttribute().size(); ++n) {
            nz.ac.waikato.adams.webservice.meka.Attribute a = d.getHeader().getAttributes().getAttribute().get(n);
            if (a.getClassAttribute() == YesNo.YES) {
                classIndex = n;
            }
            switch (a.getType()) {
                case NOMINAL: {
                    ArrayList<String> attributeVals = new ArrayList<String>();
                    for (String s : a.getLabels().getLabel()) {
                        attributeVals.add(s);
                    }
                    Attribute toAdd = new Attribute(a.getName(), attributeVals);
                    toAdd.setWeight(a.getWeight());
                    attributes.add(toAdd);
                    continue block15;
                }
                case NUMERIC: {
                    Attribute toAdd = new Attribute(a.getName());
                    toAdd.setWeight(a.getWeight());
                    attributes.add(toAdd);
                    continue block15;
                }
                case DATE: {
                    Attribute toAdd = new Attribute(a.getName(), a.getFormat());
                    toAdd.setWeight(a.getWeight());
                    attributes.add(toAdd);
                    continue block15;
                }
                case STRING: {
                    Attribute toAdd = new Attribute(a.getName(), (List)null);
                    toAdd.setWeight(a.getWeight());
                    attributes.add(toAdd);
                    continue block15;
                }
            }
        }
        Instances data = new Instances(d.getName(), attributes, 0);
        for (Instance i : d.getBody().getInstances().getInstance()) {
            double[] values = new double[i.getValue().size()];
            boolean isSparse = i.getInstanceType() == InstanceType.SPARSE;
            block18: for (n = 0; n < i.getValue().size(); ++n) {
                values[n] = Utils.missingValue();
                switch (d.getHeader().getAttributes().getAttribute().get(n).getType()) {
                    case NOMINAL: {
                        values[n] = ((Attribute)attributes.get(n)).indexOfValue(i.getValue().get(n).getValue());
                        continue block18;
                    }
                    case NUMERIC: {
                        values[n] = new Double(i.getValue().get(n).getValue());
                        continue block18;
                    }
                    case RELATIONAL: {
                        continue block18;
                    }
                    case DATE: {
                        try {
                            values[n] = data.attribute(n).parseDate(i.getValue().get(n).getValue());
                        }
                        catch (ParseException e) {
                            values[n] = Utils.missingValue();
                            e.printStackTrace();
                        }
                        continue block18;
                    }
                    case STRING: {
                        values[n] = data.attribute(n).addStringValue(i.getValue().get(n).getValue());
                    }
                }
            }
            if (isSparse) {
                data.add((weka.core.Instance)new SparseInstance(1.0, values));
                continue;
            }
            data.add((weka.core.Instance)new DenseInstance(1.0, values));
        }
        data.setClassIndex(classIndex);
        return data;
    }

    public static String datasetToString(Dataset dataset) {
        StringBuilder dataSetString = new StringBuilder();
        for (nz.ac.waikato.adams.webservice.meka.Attribute a : dataset.getHeader().getAttributes().getAttribute()) {
            dataSetString.append(a.getName() + "\t" + (Object)((Object)a.getType()) + "\t");
            if (a.getType() == Type.NOMINAL) {
                dataSetString.append("{");
                int count = 0;
                for (String s : a.getLabels().getLabel()) {
                    if (count == 0) {
                        dataSetString.append(s);
                    } else {
                        dataSetString.append(", " + s);
                    }
                    ++count;
                }
                dataSetString.append("}");
            }
            dataSetString.append("\n");
        }
        for (Instance i : dataset.getBody().getInstances().getInstance()) {
            dataSetString.append("Instance: \t ");
            for (Value v : i.getValue()) {
                dataSetString.append(v.getValue() + " ");
            }
            dataSetString.append("\n");
        }
        return dataSetString.toString();
    }

    public static void addAttribute(Dataset dataset, String name, Type type) {
        Attributes atts = dataset.getHeader().getAttributes();
        nz.ac.waikato.adams.webservice.meka.Attribute att = new nz.ac.waikato.adams.webservice.meka.Attribute();
        att.setName(name);
        att.setType(type);
        atts.getAttribute().add(att);
    }

    public static void addValue(Instance inst, int index, String value) {
        Value val = new Value();
        val.setValueIndex(0);
        val.setValue(value);
        inst.getValue().add(val);
    }

    public static void addValue(Instance inst, int index, double value) {
        Value val = new Value();
        val.setValueIndex(0);
        val.setValue("" + value);
        inst.getValue().add(val);
    }

    public static void addStatistic(Dataset dataset, String name, Object value) {
        if (!(value instanceof Number)) {
            return;
        }
        Instance inst = new Instance();
        inst.setInstanceType(InstanceType.NORMAL);
        inst.setInstanceWeight(1.0);
        dataset.getBody().getInstances().getInstance().add(inst);
        MekaDatasetHelper.addValue(inst, 0, name);
        MekaDatasetHelper.addValue(inst, 1, ((Number)value).doubleValue());
    }

    public static Dataset evaluationToDataset(Result eval) {
        Dataset result = new Dataset();
        result.setName("TODO");
        result.setVersion(MekaDatasetHelper.getDateFormat().format(new Date()));
        result.setHeader(new Header());
        result.getHeader().setAttributes(new Attributes());
        MekaDatasetHelper.addAttribute(result, "Statistic", Type.STRING);
        MekaDatasetHelper.addAttribute(result, "Value", Type.NUMERIC);
        result.setBody(new Body());
        result.getBody().setInstances(new nz.ac.waikato.adams.webservice.meka.Instances());
        ArrayList keys = new ArrayList(eval.info.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            MekaDatasetHelper.addStatistic(result, key, eval.info.get(key));
        }
        keys = new ArrayList(eval.output.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            MekaDatasetHelper.addStatistic(result, key, eval.output.get(key));
        }
        return result;
    }

    public static DateFormat getDateFormat() {
        return m_DateFormat;
    }
}

