/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Randomizable;
import adams.core.option.OptionHandler;
import adams.flow.container.MekaResultContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractCallableMekaClassifierEvaluator;
import meka.classifiers.multilabel.Evaluation;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.MLEvalUtils;
import meka.core.Result;
import weka.core.Instances;

public class MekaCrossValidationEvaluator
extends AbstractCallableMekaClassifierEvaluator
implements Randomizable,
ProvenanceSupporter {
    private static final long serialVersionUID = -3019442578354930841L;
    protected int m_Folds;
    protected long m_Seed;

    public String globalInfo() {
        return "Cross-validates a Meka classifier on an incoming dataset. The classifier setup being used in the evaluation is a callable source outputting a Meka classifier.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("folds", "folds", (Object)10, (Number)-1, null);
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"folds", (Object)this.m_Folds, (String)", folds: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"seed", (Object)this.m_Seed, (String)", seed: ");
        return result;
    }

    @Override
    public String classifierTipText() {
        return "The callable source actor for obtaining the classifier setup to cross-validate on the input data.";
    }

    public void setFolds(int value) {
        if (value == -1 || value >= 2) {
            this.m_Folds = value;
            this.reset();
        } else {
            this.getLogger().severe("Number of folds must be >=2 or -1 for LOOCV, provided: " + value);
        }
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The number of folds to use in the cross-validation; use -1 for leave-one-out cross-validation (LOOCV).";
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the cross-validation (used for randomization).";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            MultilabelClassifier cls = this.getClassifierInstance();
            if (cls == null) {
                throw new IllegalStateException("Classifier '" + this.getClassifier() + "' not found!");
            }
            Instances data = (Instances)this.m_InputToken.getPayload();
            int folds = this.m_Folds;
            if (folds == -1) {
                folds = data.numInstances();
            }
            Result[] results = Evaluation.cvModel((MultilabelClassifier)cls, (Instances)data, (int)folds, (String)"PCut1", (String)"3");
            this.m_OutputToken = new Token((Object)new MekaResultContainer(MLEvalUtils.averageResults((Result[])results)));
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to cross-validate classifier: ", e);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.EVALUATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

