/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import meka.classifiers.multilabel.BR;
import meka.classifiers.multilabel.MultiLabelClassifier;

public class MekaClassifierSetup
extends AbstractSimpleSource {
    private static final long serialVersionUID = -3019442578354930841L;
    protected MultiLabelClassifier m_Classifier;

    public String globalInfo() {
        return "Outputs an instance of the specified MEKA classifier.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new BR());
    }

    public void setClassifier(MultiLabelClassifier value) {
        this.m_Classifier = value;
        this.reset();
    }

    public MultiLabelClassifier getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The MEKA classifier to output.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"classifier", (Object)Utils.shorten((String)OptionUtils.getShortCommandLine((Object)this.m_Classifier), (int)40));
    }

    public Class[] generates() {
        return new Class[]{MultiLabelClassifier.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            MultiLabelClassifier cls = (MultiLabelClassifier)OptionUtils.shallowCopy((Object)this.m_Classifier);
            this.m_OutputToken = new Token((Object)cls);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to create copy of classifier:", e);
        }
        return result;
    }
}

