/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.container.MekaResultContainer;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractCallableMekaClassifierEvaluator;
import meka.classifiers.multilabel.Evaluation;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.Result;
import weka.core.Instances;

public class MekaTrainTestSetEvaluator
extends AbstractCallableMekaClassifierEvaluator
implements ProvenanceSupporter {
    private static final long serialVersionUID = -1092101024095887007L;

    public String globalInfo() {
        return "Trains a Meka classifier on an incoming training dataset (from a container) and then evaluates it on the test set (also from a container).\nThe classifier setup being used in the evaluation is a callable 'Classifier' actor.";
    }

    @Override
    public String classifierTipText() {
        return "The callable classifier actor to train and evaluate on the test data.";
    }

    public Class[] accepts() {
        return new Class[]{WekaTrainTestSetContainer.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            MultilabelClassifier cls = this.getClassifierInstance();
            if (cls == null) {
                throw new IllegalStateException("Classifier '" + this.getClassifier() + "' not found!");
            }
            WekaTrainTestSetContainer cont = (WekaTrainTestSetContainer)this.m_InputToken.getPayload();
            Instances train = (Instances)cont.getValue("Train");
            Instances test = (Instances)cont.getValue("Test");
            Result res = Evaluation.evaluateModel((MultilabelClassifier)cls, (Instances)train, (Instances)test, (String)"PCut1", (String)"3");
            this.m_OutputToken = new Token((Object)new MekaResultContainer(res, cls));
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to evaluate: ", e);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.EVALUATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

