/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.weka.WekaAttributeRange;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import gnu.trove.list.array.TIntArrayList;
import meka.filters.unsupervised.attribute.MekaClassAttributes;
import weka.core.Instances;
import weka.filters.Filter;

public class MekaClassSelector
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = -3019442578354930841L;
    protected WekaAttributeRange m_Range;
    protected BaseRegExp m_Regex;

    public String globalInfo() {
        return "Determines which attributes to use as class attributes using either a regular expression or an attribute index range.\nIn case the attribute range is a non-empty string, this will take precedence over the regular expression.\nAnything that follows a ':' or ' ' (blank) gets removed from the original relation name in order to create a valid MEKA one.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("range", "range", (Object)new WekaAttributeRange());
        this.m_OptionManager.add("regex", "regex", (Object)new BaseRegExp(".*"));
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"range", (Object)this.m_Range, (String)"range: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"regex", (BaseRegExp)this.m_Regex, (String)", name: ");
        return result;
    }

    public void setRange(WekaAttributeRange value) {
        this.m_Range = value;
        this.reset();
    }

    public WekaAttributeRange getRange() {
        return this.m_Range;
    }

    public String rangeTipText() {
        return "The attribute range.";
    }

    public void setRegex(BaseRegExp value) {
        this.m_Regex = value;
        this.reset();
    }

    public BaseRegExp getRegex() {
        return this.m_Regex;
    }

    public String regexTipText() {
        return "The regular expression used for selecting the class attributes (matched against the attribute names).";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{Instances.class};
    }

    protected String doExecute() {
        int[] indices;
        int i;
        String result = null;
        Instances inst = (Instances)this.m_InputToken.getPayload();
        inst = new Instances(inst);
        if (this.m_Range.getRange().isEmpty()) {
            TIntArrayList atts = new TIntArrayList();
            for (i = 0; i < inst.numAttributes(); ++i) {
                if (!this.m_Regex.isMatch(inst.attribute(i).name())) continue;
                atts.add(i);
            }
            indices = atts.toArray();
        } else {
            this.m_Range.setData((Object)inst);
            indices = this.m_Range.getIntIndices();
        }
        StringBuilder range = new StringBuilder();
        for (i = 0; i < indices.length; ++i) {
            if (i > 0) {
                range.append(",");
            }
            range.append("" + (indices[i] + 1));
        }
        try {
            MekaClassAttributes filter = new MekaClassAttributes();
            filter.setAttributeIndices(range.toString());
            filter.setInputFormat(inst);
            String oldName = inst.relationName().replaceAll(":.*", "").replaceAll(" .*", "");
            inst = Filter.useFilter((Instances)inst, (Filter)filter);
            String newName = oldName + ": -C " + indices.length;
            inst.setRelationName(newName);
            this.m_OutputToken = new Token((Object)inst);
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        catch (Exception e) {
            result = this.handleException("Failed to set class attributes!", e);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (Actor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

