/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.source.MekaClassifierSetup;
import adams.flow.transformer.AbstractTransformer;
import meka.classifiers.multilabel.MultiLabelClassifier;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class MekaTrainClassifier
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = -3019442578354930841L;
    protected CallableActorReference m_Classifier;
    protected Classifier m_ActualClassifier;

    public String globalInfo() {
        return "Trains a Meka classifier based on the incoming dataset and outputs the built classifier alongside the training header (in a model container).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new CallableActorReference(MekaClassifierSetup.class.getSimpleName()));
    }

    public void setClassifier(CallableActorReference value) {
        this.m_Classifier = value;
        this.reset();
    }

    public CallableActorReference getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The MEKA classifier to train on the input data.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"classifier", (Object)this.m_Classifier);
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{WekaModelContainer.class};
    }

    protected MultiLabelClassifier getClassifierInstance() throws Exception {
        MessageCollection errors = new MessageCollection();
        MultiLabelClassifier result = (MultiLabelClassifier)CallableActorHelper.getSetup(MultiLabelClassifier.class, (CallableActorReference)this.m_Classifier, (Actor)this, (MessageCollection)errors);
        if (result == null) {
            if (errors.isEmpty()) {
                throw new IllegalStateException("Failed to obtain classifier from '" + this.m_Classifier + "'!");
            }
            throw new IllegalStateException("Failed to obtain classifier from '" + this.m_Classifier + "':\n" + errors);
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            MultiLabelClassifier cls = this.getClassifierInstance();
            Instances data = (Instances)this.m_InputToken.getPayload();
            cls.buildClassifier(data);
            this.m_OutputToken = new Token((Object)new WekaModelContainer((Object)cls, new Instances(data, 0), data));
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process data:", e);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.MODEL_GENERATOR, this.m_InputToken.getPayload().getClass(), (Actor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

