/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.container.MekaResultContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JComponent;
import meka.core.MultiLabelDrawable;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;

public class MekaGraphVisualizer
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = -4346704926636614739L;
    protected BaseTabbedPane m_TabbedPane;

    public String globalInfo() {
        return "Displays graphs obtained from a model that implements " + MultiLabelDrawable.class.getName() + ".";
    }

    public Class[] accepts() {
        return new Class[]{MultiLabelDrawable.class, MekaResultContainer.class};
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_TabbedPane = new BaseTabbedPane();
        result.add((Component)this.m_TabbedPane, (Object)"Center");
        return result;
    }

    public boolean supportsClear() {
        return true;
    }

    public void clearPanel() {
        if (this.m_TabbedPane != null) {
            this.m_TabbedPane.removeAll();
        }
    }

    protected void display(Token token) {
        ArrayList keys;
        Map graphs;
        Map types;
        MultiLabelDrawable model = token.getPayload() instanceof MultiLabelDrawable ? (MultiLabelDrawable)token.getPayload() : (MultiLabelDrawable)((MekaResultContainer)((Object)token.getPayload())).getValue("Model");
        try {
            types = model.graphType();
            graphs = model.graph();
            keys = new ArrayList(types.keySet());
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, "Failed to obtain graph(s):", (Throwable)ex);
            return;
        }
        for (Integer label : keys) {
            int type = (Integer)types.get(label);
            GraphVisualizer comp = null;
            switch (type) {
                case 1: {
                    TreeBuild b = new TreeBuild();
                    PlaceNode2 arrange = new PlaceNode2();
                    Node top = b.create((Reader)new StringReader((String)graphs.get(label)));
                    comp = new TreeVisualizer(null, top, (NodePlace)arrange);
                    break;
                }
                case 2: {
                    GraphVisualizer g = new GraphVisualizer();
                    g.readDOT((Reader)new StringReader((String)graphs.get(label)));
                    comp = g;
                    break;
                }
                default: {
                    System.err.println("Unsupported graph type for label " + label + ": " + type);
                }
            }
            if (comp == null) continue;
            this.m_TabbedPane.addTab("" + label, comp);
        }
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    public DisplayPanel createDisplayPanel(Token token) {
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = 4356468458332186521L;
            protected BaseTabbedPane m_TabbedPane;

            protected void initGUI() {
                super.initGUI();
                this.m_TabbedPane = new BaseTabbedPane();
                this.add((Component)this.m_TabbedPane, "Center");
            }

            public void display(Token token) {
                ArrayList keys;
                Map graphs;
                Map types;
                MultiLabelDrawable model = token.getPayload() instanceof MultiLabelDrawable ? (MultiLabelDrawable)token.getPayload() : (MultiLabelDrawable)((MekaResultContainer)((Object)token.getPayload())).getValue("Model");
                try {
                    types = model.graphType();
                    graphs = model.graph();
                    keys = new ArrayList(types.keySet());
                }
                catch (Exception ex) {
                    MekaGraphVisualizer.this.getLogger().log(Level.SEVERE, "Failed to obtain graph(s):", (Throwable)ex);
                    return;
                }
                for (Integer label : keys) {
                    int type = (Integer)types.get(label);
                    GraphVisualizer comp = null;
                    switch (type) {
                        case 1: {
                            TreeBuild b = new TreeBuild();
                            PlaceNode2 arrange = new PlaceNode2();
                            Node top = b.create((Reader)new StringReader((String)graphs.get(label)));
                            comp = new TreeVisualizer(null, top, (NodePlace)arrange);
                            break;
                        }
                        case 2: {
                            GraphVisualizer g = new GraphVisualizer();
                            g.readDOT((Reader)new StringReader((String)graphs.get(label)));
                            comp = g;
                            break;
                        }
                        default: {
                            System.err.println("Unsupported graph type for label " + label + ": " + type);
                        }
                    }
                    if (comp == null) continue;
                    this.m_TabbedPane.addTab("" + label, comp);
                }
            }

            public void clearPanel() {
                this.m_TabbedPane.removeAll();
            }

            public void cleanUp() {
                this.m_TabbedPane.removeAll();
            }

            public JComponent supplyComponent() {
                return this.m_TabbedPane;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }
}

