/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.logging.LoggingLevel;
import adams.flow.control.AbstractControlActor;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.MutableActorHandler;
import adams.flow.standalone.StandaloneGroup;
import adams.flow.standalone.StandaloneGroupItem;

public abstract class AbstractMutableStandaloneGroupItem<T extends Actor>
extends AbstractControlActor
implements MutableActorHandler,
StandaloneGroupItem<T> {
    private static final long serialVersionUID = -2130921331341838430L;
    protected MutableActorHandler m_Actors;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor", "actors", (Object)new AbstractActor[0]);
    }

    protected void initialize() {
        super.initialize();
        this.m_Actors = this.newActorHandler();
    }

    protected abstract MutableActorHandler newActorHandler();

    public void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_Actors.setLoggingLevel(value);
    }

    @Override
    public T getEnclosingGroup() {
        if (this.getParent() == null) {
            return null;
        }
        if (this.getParent() instanceof StandaloneGroup) {
            return (T)this.getParent();
        }
        return null;
    }

    public String check() {
        return this.checkSubActors(this.getActors());
    }

    protected abstract String checkSubActor(int var1, AbstractActor var2);

    protected abstract String checkSubActors(AbstractActor[] var1);

    public void setActors(AbstractActor[] value) {
        String msg = this.checkSubActors(value);
        if (msg == null) {
            this.m_Actors.removeAll();
            for (AbstractActor actor : value) {
                this.m_Actors.add(actor);
            }
        } else {
            throw new IllegalArgumentException(msg);
        }
        this.reset();
        this.updateParent();
    }

    public AbstractActor[] getActors() {
        AbstractActor[] result = new AbstractActor[this.m_Actors.size()];
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            result[i] = this.m_Actors.get(i);
        }
        return result;
    }

    public abstract String actorsTipText();

    protected void updateParent() {
        this.m_Actors.setName(this.getName());
        this.m_Actors.setParent(null);
        this.m_Actors.setParent(this.getParent());
    }

    public int size() {
        return this.m_Actors.size();
    }

    public AbstractActor get(int index) {
        return this.m_Actors.get(index);
    }

    public void set(int index, AbstractActor actor) {
        String msg = this.checkSubActor(index, actor);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.set(index, actor);
        this.reset();
        this.updateParent();
    }

    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    public void add(AbstractActor actor) {
        this.add(this.size(), actor);
    }

    public void add(int index, AbstractActor actor) {
        String msg = this.checkSubActor(index, actor);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.add(index, actor);
        this.reset();
        this.updateParent();
    }

    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    public void removeAll() {
        this.m_Actors.removeAll();
        this.reset();
    }

    protected MutableActorHandler getInternalActors() {
        return this.m_Actors;
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return this.m_Actors.getActorHandlerInfo();
    }

    protected abstract String doSetUpSubActors();

    protected String setUpSubActors() {
        String result = null;
        if (!this.getSkip()) {
            this.updateParent();
            result = this.doSetUpSubActors();
            if (result == null) {
                result = this.m_Actors.setUp();
            }
        }
        return result;
    }

    protected String doExecute() {
        return null;
    }

    public void cleanUp() {
        this.m_Actors.cleanUp();
        super.cleanUp();
    }
}

