/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Variables;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.standalone.StandaloneGroup;
import adams.flow.standalone.StandaloneGroupItem;
import java.util.List;

public abstract class AbstractStandaloneGroup<T extends Actor>
extends AbstractStandalone
implements StandaloneGroup<T> {
    private static final long serialVersionUID = -739244942139022557L;
    protected List<T> m_Actors;

    protected void initialize() {
        super.initialize();
        this.m_Actors = this.getDefaultActors();
    }

    protected abstract List<T> getDefaultActors();

    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, false, ActorExecution.UNDEFINED, false, new Class[]{StandaloneGroupItem.class});
    }

    protected void updateParent() {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setParent(null);
            this.get(i).setParent((AbstractActor)this);
        }
    }

    protected String checkActors(AbstractActor[] actors) {
        for (int i = 0; i < actors.length; ++i) {
            String msg = this.checkActor(actors[i], i);
            if (msg == null) continue;
            return msg;
        }
        return null;
    }

    protected String checkActor(AbstractActor actor) {
        return this.checkActor(actor, -1);
    }

    protected abstract String checkActor(AbstractActor var1, int var2);

    public int size() {
        return this.m_Actors.size();
    }

    protected void setActors(AbstractActor[] value) {
        String msg = this.checkActors(value);
        if (msg != null) {
            this.getLogger().warning(msg);
            return;
        }
        this.m_Actors.clear();
        for (AbstractActor actor : value) {
            this.m_Actors.add(actor);
        }
        this.reset();
        this.updateParent();
    }

    protected AbstractActor[] getActors() {
        return this.m_Actors.toArray(new AbstractActor[this.m_Actors.size()]);
    }

    public AbstractActor get(int index) {
        return (AbstractActor)this.m_Actors.get(index);
    }

    public void set(int index, AbstractActor actor) {
        String msg = this.checkActor(actor, index);
        if (msg == null) {
            this.m_Actors.set(index, actor);
            this.reset();
            this.updateParent();
        } else {
            this.getLogger().severe(msg);
        }
    }

    public int indexOf(String actor) {
        int result = -1;
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (!((Actor)this.m_Actors.get(i)).getName().equals(actor)) continue;
            result = i;
            break;
        }
        return result;
    }

    public abstract String check();

    public AbstractActor firstActive() {
        AbstractActor result = null;
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (((Actor)this.m_Actors.get(i)).getSkip()) continue;
            result = (AbstractActor)this.m_Actors.get(i);
            break;
        }
        return result;
    }

    public AbstractActor lastActive() {
        AbstractActor result = null;
        for (int i = this.m_Actors.size() - 1; i >= 0; --i) {
            if (((Actor)this.m_Actors.get(i)).getSkip()) continue;
            result = (AbstractActor)this.m_Actors.get(i);
            break;
        }
        return result;
    }

    public Actor find(String name) {
        Actor result = null;
        for (Actor actor : this.m_Actors) {
            if (actor.getSkip()) continue;
            if (actor.getName().equals(name)) {
                result = actor;
                break;
            }
            if (!(actor instanceof AbstractStandaloneGroup) || (result = ((AbstractStandaloneGroup)actor).find(name)) == null) continue;
            break;
        }
        return result;
    }

    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setVariables(value);
        }
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.check();
        }
        if (result == null) {
            for (int i = 0; i < this.m_Actors.size(); ++i) {
                if (((Actor)this.m_Actors.get(i)).getSkip() || (result = ((Actor)this.m_Actors.get(i)).setUp()) == null) continue;
                result = "Actor #" + (i + 1) + " failed setup: " + result;
                break;
            }
        }
        return result;
    }

    protected abstract String doExecute();

    public void flushExecution() {
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (((Actor)this.m_Actors.get(i)).getSkip() || !(this.m_Actors.get(i) instanceof ActorHandler)) continue;
            ((ActorHandler)this.m_Actors.get(i)).flushExecution();
        }
    }

    public void stopExecution() {
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Stopping " + (i + 1) + "/" + this.m_Actors.size());
            }
            if (((Actor)this.m_Actors.get(i)).getSkip()) {
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().info("Skipped " + (i + 1) + "/" + this.m_Actors.size());
                continue;
            }
            ((Actor)this.m_Actors.get(i)).stopExecution();
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().info("Stopped " + (i + 1) + "/" + this.m_Actors.size());
        }
        super.stopExecution();
    }

    public void wrapUp() {
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Wrapping up " + (i + 1) + "/" + this.m_Actors.size());
            }
            if (((Actor)this.m_Actors.get(i)).getSkip()) {
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().info("Skipped " + (i + 1) + "/" + this.m_Actors.size());
                continue;
            }
            ((Actor)this.m_Actors.get(i)).wrapUp();
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().info("Wrapped up " + (i + 1) + "/" + this.m_Actors.size());
        }
        super.wrapUp();
    }

    public void cleanUp() {
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Cleaning up " + (i + 1) + "/" + this.m_Actors.size());
            }
            if (((Actor)this.m_Actors.get(i)).getSkip()) {
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().info("Skipped " + (i + 1) + "/" + this.m_Actors.size());
                continue;
            }
            ((Actor)this.m_Actors.get(i)).cleanUp();
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().info("Cleaned up " + (i + 1) + "/" + this.m_Actors.size());
        }
        super.cleanUp();
    }
}

