/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.output.FlowWriter;
import adams.data.io.output.JsonFlowWriter;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.FlowFileWriter;
import adams.flow.source.NewFlow;
import adams.flow.template.AbstractActorTemplate;
import adams.flow.template.PromptUser;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class FlowFileWriterTest
extends AbstractFlowTest {
    public FlowFileWriterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(FlowFileWriterTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            NewFlow newflow = new NewFlow();
            PromptUser promptuser = new PromptUser();
            newflow.setTemplate((AbstractActorTemplate)promptuser);
            actors.add(newflow);
            FlowFileWriter flowfilewriter = new FlowFileWriter();
            AbstractArgumentOption argOption = (AbstractArgumentOption)flowfilewriter.getOptionManager().findByProperty("outputFile");
            flowfilewriter.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            flowfilewriter.setUseCustomWriter(true);
            JsonFlowWriter jsonflowwriter = new JsonFlowWriter();
            flowfilewriter.setCustomWriter((FlowWriter)jsonflowwriter);
            actors.add(flowfilewriter);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            FlowFileWriterTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        FlowFileWriterTest.runTest((Test)FlowFileWriterTest.suite());
    }
}

