/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Utils;
import adams.core.Variables;
import adams.flow.core.Actor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.standalone.StandaloneGroup;
import adams.flow.standalone.StandaloneGroupItem;
import java.util.ArrayList;
import java.util.List;
import nz.ac.waikato.cms.locator.ClassLocator;

public abstract class AbstractStandaloneGroup<T extends Actor>
extends AbstractStandalone
implements StandaloneGroup<T> {
    private static final long serialVersionUID = -739244942139022557L;
    protected List<T> m_Actors;

    protected void initialize() {
        super.initialize();
        this.m_Actors = this.getDefaultActors();
        this.updateParent();
    }

    protected abstract List<T> getDefaultActors();

    protected Class[] getActorFilter() {
        return new Class[]{StandaloneGroupItem.class};
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo().allowStandalones(true).allowSource(false).actorExecution(ActorExecution.UNDEFINED).forwardsInput(false).restrictions(this.getActorFilter());
    }

    public void setParent(Actor value) {
        super.setParent(value);
        this.updateParent();
    }

    protected void updateParent() {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setParent(null);
            this.get(i).setParent((Actor)this);
        }
    }

    protected String checkActors(Actor[] actors) {
        for (int i = 0; i < actors.length; ++i) {
            String msg = this.checkActor(actors[i], i);
            if (msg == null) continue;
            return msg;
        }
        return null;
    }

    protected String checkActor(Actor actor) {
        return this.checkActor(actor, -1);
    }

    protected String checkActor(Actor actor, int index) {
        String result = null;
        Class[] accepted = this.getActorFilter();
        boolean found = false;
        for (Class cls : accepted) {
            if (!ClassLocator.matches((Class)cls, actor.getClass())) continue;
            found = true;
            break;
        }
        if (!found) {
            result = "Actor #" + (index + 1) + " (" + Utils.classToString((Object)actor) + ") is not of type: " + Utils.classesToString((Class[])accepted);
        }
        return result;
    }

    public int size() {
        return this.m_Actors.size();
    }

    protected void setActors(Actor[] value) {
        String msg = this.checkActors(value);
        if (msg != null) {
            this.getLogger().warning(msg);
            return;
        }
        this.m_Actors.clear();
        for (Actor actor : value) {
            this.m_Actors.add(actor);
            ActorUtils.uniqueName((Actor)actor, (ActorHandler)this, (int)(this.m_Actors.size() - 1));
        }
        this.reset();
        this.updateParent();
    }

    protected Actor[] getActors() {
        return this.m_Actors.toArray(new Actor[this.m_Actors.size()]);
    }

    public Actor get(int index) {
        return (Actor)this.m_Actors.get(index);
    }

    public String set(int index, Actor actor) {
        String result = this.checkActor(actor, index);
        if (result == null) {
            ActorUtils.uniqueName((Actor)actor, (ActorHandler)this, (int)index);
            this.m_Actors.set(index, actor);
            this.reset();
            this.updateParent();
        } else {
            this.getLogger().severe(result);
        }
        return result;
    }

    public int indexOf(String actor) {
        int result = -1;
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (!((Actor)this.m_Actors.get(i)).getName().equals(actor)) continue;
            result = i;
            break;
        }
        return result;
    }

    public abstract String check();

    public Actor firstActive() {
        Actor result = null;
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (((Actor)this.m_Actors.get(i)).getSkip()) continue;
            result = (Actor)this.m_Actors.get(i);
            break;
        }
        return result;
    }

    public Actor lastActive() {
        Actor result = null;
        for (int i = this.m_Actors.size() - 1; i >= 0; --i) {
            if (((Actor)this.m_Actors.get(i)).getSkip()) continue;
            result = (Actor)this.m_Actors.get(i);
            break;
        }
        return result;
    }

    public Actor find(String name) {
        Actor result = null;
        for (Actor actor : this.m_Actors) {
            if (actor.getSkip()) continue;
            if (actor.getName().equals(name)) {
                result = actor;
                break;
            }
            if (!(actor instanceof AbstractStandaloneGroup) || (result = ((AbstractStandaloneGroup)actor).find(name)) == null) continue;
            break;
        }
        return result;
    }

    public boolean hasActor(Class actor) {
        boolean result = false;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).getClass().equals(actor) || this.get(i).getSkip()) continue;
            result = true;
            break;
        }
        return result;
    }

    public <A extends Actor> List<A> getActors(Class<A> actor) {
        ArrayList<Actor> result = new ArrayList<Actor>();
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).getClass().equals(actor) || this.get(i).getSkip()) continue;
            result.add(this.get(i));
            break;
        }
        return result;
    }

    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getSkip()) continue;
            this.get(i).setVariables(value);
        }
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.check();
        }
        if (result == null) {
            for (int i = 0; i < this.m_Actors.size(); ++i) {
                if (((Actor)this.m_Actors.get(i)).getSkip()) continue;
                result = this.checkActor((Actor)this.m_Actors.get(i), i);
                if (result == null) {
                    result = ((Actor)this.m_Actors.get(i)).setUp();
                }
                if (result == null) continue;
                result = ((Actor)this.m_Actors.get(i)).getFullName() + ": " + result;
                break;
            }
        }
        return result;
    }

    protected abstract String doExecute();

    public void flushExecution() {
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (((Actor)this.m_Actors.get(i)).getSkip() || !(this.m_Actors.get(i) instanceof ActorHandler)) continue;
            ((ActorHandler)this.m_Actors.get(i)).flushExecution();
        }
    }

    public void stopExecution() {
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Stopping " + (i + 1) + "/" + this.m_Actors.size());
            }
            if (((Actor)this.m_Actors.get(i)).getSkip()) {
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().info("Skipped " + (i + 1) + "/" + this.m_Actors.size());
                continue;
            }
            ((Actor)this.m_Actors.get(i)).stopExecution();
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().info("Stopped " + (i + 1) + "/" + this.m_Actors.size());
        }
        super.stopExecution();
    }

    public void wrapUp() {
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Wrapping up " + (i + 1) + "/" + this.m_Actors.size());
            }
            if (((Actor)this.m_Actors.get(i)).getSkip()) {
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().info("Skipped " + (i + 1) + "/" + this.m_Actors.size());
                continue;
            }
            ((Actor)this.m_Actors.get(i)).wrapUp();
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().info("Wrapped up " + (i + 1) + "/" + this.m_Actors.size());
        }
        super.wrapUp();
    }

    public void cleanUp() {
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Cleaning up " + (i + 1) + "/" + this.m_Actors.size());
            }
            if (((Actor)this.m_Actors.get(i)).getSkip()) {
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().info("Skipped " + (i + 1) + "/" + this.m_Actors.size());
                continue;
            }
            ((Actor)this.m_Actors.get(i)).cleanUp();
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().info("Cleaned up " + (i + 1) + "/" + this.m_Actors.size());
        }
        super.cleanUp();
    }
}

