/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.ArrayProducer;
import adams.core.option.JenericCommandLineHandler;
import adams.core.option.OptionUtils;
import adams.data.io.input.DefaultFlowReader;
import adams.data.io.input.FlowReader;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.FlowFileReader;
import adams.flow.transformer.OptionProducer;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class FlowFileReaderTest
extends AbstractFlowTest {
    public FlowFileReaderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(FlowFileReaderTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${CWD}/src/test/resources/adams/flow/data/external_transformer.flow"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            FlowFileReader flowfilereader = new FlowFileReader();
            DefaultFlowReader defaultflowreader = new DefaultFlowReader();
            flowfilereader.setCustomReader((FlowReader)defaultflowreader);
            actors.add(flowfilereader);
            OptionProducer optionproducer = new OptionProducer();
            ArrayProducer arrayproducer = new ArrayProducer();
            JenericCommandLineHandler jenericcommandlinehandler = new JenericCommandLineHandler();
            jenericcommandlinehandler.setOptions((Object)arrayproducer, OptionUtils.splitOptions((String)"-logging-level OFF -output-variable-values false"));
            optionproducer.setProducer((adams.core.option.OptionProducer)arrayproducer);
            actors.add(optionproducer);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            FlowFileReaderTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        FlowFileReaderTest.runTest((Test)FlowFileReaderTest.suite());
    }
}

