/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option.help;

import adams.core.Utils;
import adams.core.net.HtmlUtils;
import adams.core.option.help.AbstractHelpGenerator;
import adams.core.option.help.HelpFormat;
import adams.core.tags.TagDataType;
import adams.core.tags.TagInfo;
import adams.core.tags.TagProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import nz.ac.waikato.cms.locator.ClassLocator;

public class SupportedTags
extends AbstractHelpGenerator {
    private static final long serialVersionUID = -3885494293535045819L;
    protected String m_Title;

    public String globalInfo() {
        return "Generates help for classes that implement the " + Utils.classToString(TagProcessor.class) + " interface.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("title", "title", (Object)"Supported tags");
    }

    public void setTitle(String value) {
        this.m_Title = value;
        this.reset();
    }

    public String getTitle() {
        return this.m_Title;
    }

    public String titleTipText() {
        return "The title to use in the help output.";
    }

    public boolean handles(Class cls) {
        return ClassLocator.matches(TagProcessor.class, (Class)cls);
    }

    public String generate(Object obj, HelpFormat format) {
        StringBuilder result = new StringBuilder();
        Set<TagInfo> tags = ((TagProcessor)obj).getSupportedTags();
        if (tags.size() > 0) {
            ArrayList<TagInfo> sorted = new ArrayList<TagInfo>(tags);
            Collections.sort(sorted);
            switch (format) {
                case PLAIN_TEXT: {
                    result.append(this.m_Title).append("\n");
                    for (TagInfo tag : sorted) {
                        result.append("- ").append(tag.getName()).append("\n");
                        result.append("  ").append(tag.getInformation()).append("\n");
                        result.append("  type: ").append((Object)tag.getDataType());
                        if (tag.getDataType() == TagDataType.BOOLEAN) {
                            result.append(" (true|false)");
                        }
                        result.append("\n");
                        if (tag.getAppliesTo().length <= 0) continue;
                        result.append("  can be attached to:\n");
                        for (Class cls : tag.getAppliesTo()) {
                            result.append("  - ").append(Utils.classToString((Class)cls)).append("\n");
                        }
                    }
                    result.append("\n");
                    break;
                }
                case HTML: {
                    result.append("<h2>").append(this.m_Title).append("</h2>\n");
                    result.append("<ul>\n");
                    for (TagInfo tag : sorted) {
                        result.append("<li>");
                        result.append("<b>").append(HtmlUtils.toHTML((String)tag.getName())).append("</b>");
                        result.append("<br>");
                        result.append("\n");
                        result.append(HtmlUtils.toHTML((String)tag.getInformation()));
                        result.append("<br>");
                        result.append("\n");
                        result.append("<i>type:</i> ").append((Object)tag.getDataType());
                        if (tag.getDataType() == TagDataType.BOOLEAN) {
                            result.append(" (true|false)");
                        }
                        if (tag.getAppliesTo().length > 0) {
                            result.append("<br>");
                            result.append("\n");
                            result.append("<i>can be attached to:</i>\n");
                            result.append("<ul>");
                            for (Class cls : tag.getAppliesTo()) {
                                result.append("  <li>").append(Utils.classToString((Class)cls)).append("</li>\n");
                            }
                            result.append("</ul>");
                        }
                        result.append("</li>\n");
                    }
                    result.append("</ul>\n");
                    result.append("\n");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled format: " + format);
                }
            }
        }
        return result.toString();
    }
}

