/*
 * Decompiled with CFR 0.152.
 */
package adams.core.tags;

import adams.core.base.BaseKeyValuePair;
import adams.core.tags.TagHandler;
import adams.flow.core.Actor;
import adams.gui.flow.tree.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TagProcessorHelper {
    public static boolean hasTag(Object obj, String tag) {
        if (!(obj instanceof TagHandler)) {
            return false;
        }
        List<BaseKeyValuePair> tags = ((TagHandler)obj).getAllTags();
        for (BaseKeyValuePair t : tags) {
            if (!t.getPairKey().equals(tag)) continue;
            return true;
        }
        return false;
    }

    protected static String getTagValue(Object obj, String tag) {
        if (!(obj instanceof TagHandler)) {
            return null;
        }
        List<BaseKeyValuePair> tags = ((TagHandler)obj).getAllTags();
        for (BaseKeyValuePair t : tags) {
            if (!t.getPairKey().equals(tag)) continue;
            return t.getPairValue();
        }
        return null;
    }

    public static String getTagString(Object obj, String tag, String defValue) {
        String result = TagProcessorHelper.getTagValue(obj, tag);
        if (result == null) {
            result = defValue;
        }
        return result;
    }

    public static boolean getTagBoolean(Object obj, String tag, boolean defValue) {
        boolean result = defValue;
        String value = TagProcessorHelper.getTagValue(obj, tag);
        if (value != null) {
            try {
                result = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                result = defValue;
            }
        }
        return result;
    }

    public static byte getTagByte(Object obj, String tag, byte defValue) {
        byte result = defValue;
        String value = TagProcessorHelper.getTagValue(obj, tag);
        if (value != null) {
            try {
                result = Byte.parseByte(value);
            }
            catch (Exception e) {
                result = defValue;
            }
        }
        return result;
    }

    public static int getTagInt(Object obj, String tag, int defValue) {
        int result = defValue;
        String value = TagProcessorHelper.getTagValue(obj, tag);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (Exception e) {
                result = defValue;
            }
        }
        return result;
    }

    public static long getTagLong(Object obj, String tag, long defValue) {
        long result = defValue;
        String value = TagProcessorHelper.getTagValue(obj, tag);
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (Exception e) {
                result = defValue;
            }
        }
        return result;
    }

    public static float getTagFloat(Object obj, String tag, float defValue) {
        float result = defValue;
        String value = TagProcessorHelper.getTagValue(obj, tag);
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (Exception e) {
                result = defValue;
            }
        }
        return result;
    }

    public static double getTagDouble(Object obj, String tag, double defValue) {
        double result = defValue;
        String value = TagProcessorHelper.getTagValue(obj, tag);
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (Exception e) {
                result = defValue;
            }
        }
        return result;
    }

    public static List<BaseKeyValuePair> getAllTags(TagHandler handler) {
        return new ArrayList<BaseKeyValuePair>(handler.getAllTags());
    }

    protected static void addToMap(Map<String, BaseKeyValuePair> map, List<BaseKeyValuePair> tags, boolean override) {
        TagProcessorHelper.addToMap(map, tags.toArray(new BaseKeyValuePair[tags.size()]), override);
    }

    protected static void addToMap(Map<String, BaseKeyValuePair> map, BaseKeyValuePair[] tags, boolean override) {
        for (BaseKeyValuePair tag : tags) {
            if (map.containsKey(tag.getPairValue()) && override) {
                map.put(tag.getPairKey(), tag);
                continue;
            }
            if (map.containsKey(tag.getPairKey())) continue;
            map.put(tag.getPairKey(), tag);
        }
    }

    public static List<BaseKeyValuePair> getAllTags(Actor actor, boolean traverse) {
        HashMap<String, BaseKeyValuePair> tags = new HashMap<String, BaseKeyValuePair>();
        if (actor instanceof TagHandler) {
            TagProcessorHelper.addToMap(tags, ((TagHandler)actor).getTags(), false);
        }
        if (traverse) {
            for (Actor parent = actor.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof TagHandler)) continue;
                TagProcessorHelper.addToMap(tags, ((TagHandler)parent).getAllTags(), false);
                break;
            }
        }
        ArrayList<BaseKeyValuePair> result = new ArrayList<BaseKeyValuePair>(tags.values());
        return result;
    }

    public static List<BaseKeyValuePair> getAllTags(Node node, boolean traverse) {
        HashMap<String, BaseKeyValuePair> tags = new HashMap<String, BaseKeyValuePair>();
        if (node.getActor() instanceof TagHandler) {
            TagProcessorHelper.addToMap(tags, ((TagHandler)node.getActor()).getTags(), false);
        }
        if (traverse) {
            for (Node parent = (Node)node.getParent(); parent != null; parent = (Node)parent.getParent()) {
                if (!(parent.getActor() instanceof TagHandler)) continue;
                TagProcessorHelper.addToMap(tags, TagProcessorHelper.getAllTags(parent, traverse), false);
                break;
            }
        }
        ArrayList<BaseKeyValuePair> result = new ArrayList<BaseKeyValuePair>(tags.values());
        return result;
    }
}

