/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.core.Variables;
import adams.flow.container.AbstractContainer;
import adams.flow.control.Storage;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import java.util.ArrayList;
import java.util.Iterator;

public class EncapsulatedActorsContainer
extends AbstractContainer {
    private static final long serialVersionUID = -418617166464706249L;
    public static final String VALUE_ACTOR = "Actor";
    public static final String VALUE_VARIABLES = "Variables";
    public static final String VALUE_STORAGE = "Storage";
    public static final String VALUE_INPUT = "Input";
    public static final String VALUE_INPUTNAME = "Input name";
    public static final String VALUE_OUTPUT = "Output";
    public static final String VALUE_OUTPUTNAME = "Output name";

    public EncapsulatedActorsContainer() {
        this(null, null, null);
    }

    public EncapsulatedActorsContainer(Actor actor, Variables variables, Storage storage) {
        this(actor, variables, storage, null, null);
    }

    public EncapsulatedActorsContainer(Actor actor, Variables variables, Storage storage, Object input, StorageName inputName) {
        this(actor, variables, storage, input, inputName, null, null);
    }

    public EncapsulatedActorsContainer(Actor actor, Variables variables, Storage storage, Object input, StorageName inputName, Object output, StorageName outputName) {
        this.store(VALUE_ACTOR, actor);
        this.store(VALUE_VARIABLES, variables);
        this.store(VALUE_STORAGE, storage);
        this.store(VALUE_INPUT, input);
        this.store(VALUE_INPUTNAME, inputName);
        this.store(VALUE_OUTPUT, output);
        this.store(VALUE_OUTPUTNAME, outputName);
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_ACTOR);
        result.add(VALUE_VARIABLES);
        result.add(VALUE_STORAGE);
        result.add(VALUE_INPUT);
        result.add(VALUE_INPUTNAME);
        result.add(VALUE_OUTPUT);
        result.add(VALUE_OUTPUTNAME);
        return result.iterator();
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_ACTOR, "actor to encapsulate", Actor.class);
        this.addHelp(VALUE_VARIABLES, "the variables", Variables.class);
        this.addHelp(VALUE_STORAGE, "the storage items", Storage.class);
        this.addHelp(VALUE_INPUT, "the optional input", Object.class);
        this.addHelp(VALUE_INPUTNAME, "the storage name of the optional input", StorageName.class);
        this.addHelp(VALUE_OUTPUT, "the optional generated output", Object.class);
        this.addHelp(VALUE_OUTPUTNAME, "the storage name of the optional generated output", StorageName.class);
    }

    public boolean isValid() {
        return this.hasValue(VALUE_ACTOR) && this.hasValue(VALUE_VARIABLES) && this.hasValue(VALUE_STORAGE);
    }
}

