/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.VariableName;
import adams.core.Variables;
import adams.flow.container.EncapsulatedActorsContainer;
import adams.flow.control.Flow;
import adams.flow.control.Storage;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.source.Start;
import adams.flow.source.StorageValue;
import adams.flow.transformer.SetStorageValue;
import java.util.Arrays;
import java.util.HashSet;

public class EncapsulateActors {
    public static Variables getVariables(Actor context, VariableName[] vars) {
        Variables result = new Variables();
        Variables source = context.getVariables();
        for (VariableName var : vars) {
            if (!source.has(var.getValue())) continue;
            result.set(var.getValue(), source.get(var.getValue()));
        }
        return result;
    }

    public static Storage getStorage(Actor context, StorageName[] items) {
        Storage result = new Storage();
        Storage source = context.getStorageHandler().getStorage();
        for (StorageName item : items) {
            if (!source.has(item)) continue;
            result.put(item, source.get(item));
        }
        return result;
    }

    protected static StorageName createStorageName(StorageName[] items, String prefix) {
        HashSet<StorageName> names = new HashSet<StorageName>(Arrays.asList(items));
        StorageName result = new StorageName(prefix);
        int count = 0;
        while (names.contains(result)) {
            result = new StorageName(prefix + ++count);
        }
        return result;
    }

    public static StorageName createInputStorageName(StorageName[] items) {
        return EncapsulateActors.createStorageName(items, "input");
    }

    public static StorageName createOutputStorageName(StorageName[] items) {
        return EncapsulateActors.createStorageName(items, "output");
    }

    public static EncapsulatedActorsContainer encapsulate(Actor actor, VariableName[] vars, StorageName[] items) {
        return EncapsulateActors.encapsulate(actor, vars, items, null);
    }

    public static EncapsulatedActorsContainer encapsulate(Actor actor, VariableName[] vars, StorageName[] items, Object input) {
        return new EncapsulatedActorsContainer(actor, EncapsulateActors.getVariables(actor, vars), EncapsulateActors.getStorage(actor, items), input, null);
    }

    public static EncapsulatedActorsContainer wrap(Actor actor, VariableName[] vars, StorageName[] items) {
        return EncapsulateActors.wrap(actor, vars, items, null);
    }

    public static EncapsulatedActorsContainer wrap(Actor actor, VariableName[] vars, StorageName[] items, Object input) {
        if (actor instanceof Flow) {
            return EncapsulateActors.encapsulate(actor.shallowCopy(false), vars, items);
        }
        Variables variables = EncapsulateActors.getVariables(actor, vars);
        Storage storage = EncapsulateActors.getStorage(actor, items);
        StorageName inputName = null;
        StorageName outputName = null;
        if (actor instanceof InputConsumer) {
            Flow flow = new Flow();
            if (input != null) {
                inputName = EncapsulateActors.createInputStorageName(items);
                storage.put(inputName, input);
                StorageValue sv = new StorageValue();
                sv.setStorageName(inputName);
                flow.add((Actor)sv);
            } else {
                flow.add((Actor)new Start());
            }
            flow.add(actor);
            if (actor instanceof OutputProducer) {
                outputName = EncapsulateActors.createOutputStorageName(items);
                SetStorageValue ssv = new SetStorageValue();
                ssv.setStorageName(outputName);
                flow.add((Actor)ssv);
            }
            actor = flow;
        } else {
            Flow flow = new Flow();
            flow.add(actor);
            if (actor instanceof OutputProducer) {
                outputName = EncapsulateActors.createOutputStorageName(items);
                SetStorageValue ssv = new SetStorageValue();
                ssv.setStorageName(outputName);
                flow.add((Actor)ssv);
            }
            actor = flow;
        }
        return new EncapsulatedActorsContainer(actor.shallowCopy(false), variables, storage, input, inputName, null, outputName);
    }
}

