/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.Utils;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandler;
import adams.flow.core.AutogeneratedActor;
import adams.flow.core.MutableActorHandler;
import adams.flow.processor.AbstractModifyingProcessor;
import adams.flow.processor.CleanUpProcessor;

public class RemoveAutogeneratedActors
extends AbstractModifyingProcessor
implements CleanUpProcessor {
    private static final long serialVersionUID = -8658024993875114313L;

    public String globalInfo() {
        return "Removes all actors implementing the " + Utils.classToString(AutogeneratedActor.class) + ". If an actor cannot be removed, it gets disabled.";
    }

    protected void processActor(Actor actor) {
        block6: {
            int i;
            if (!(actor instanceof ActorHandler)) break block6;
            ActorHandler handler = (ActorHandler)actor;
            if (handler instanceof MutableActorHandler) {
                MutableActorHandler mutable = (MutableActorHandler)handler;
                i = 0;
                while (i < mutable.size()) {
                    if (mutable.get(i) instanceof AutogeneratedActor) {
                        mutable.remove(i);
                        this.m_Modified = true;
                        continue;
                    }
                    ++i;
                }
            } else {
                for (i = 0; i < handler.size(); ++i) {
                    if (!(handler.get(i) instanceof AutogeneratedActor)) continue;
                    handler.get(i).setSkip(true);
                    this.m_Modified = true;
                }
            }
            for (i = 0; i < handler.size(); ++i) {
                this.processActor(handler.get(i));
            }
        }
    }
}

