/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.NestedProducer;
import adams.core.option.OptionProducer;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.CurrentFlow;
import adams.flow.transformer.StringJoin;
import adams.flow.transformer.StringMatcher;
import adams.flow.transformer.StringSplit;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class CurrentFlowTest
extends AbstractFlowTest {
    public CurrentFlowTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(CurrentFlowTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            CurrentFlow newflow = new CurrentFlow();
            actors.add(newflow);
            adams.flow.transformer.OptionProducer optionproducer = new adams.flow.transformer.OptionProducer();
            NestedProducer nestedproducer = new NestedProducer();
            optionproducer.setProducer((OptionProducer)nestedproducer);
            actors.add(optionproducer);
            StringSplit stringsplit = new StringSplit();
            AbstractArgumentOption argOption = (AbstractArgumentOption)stringsplit.getOptionManager().findByProperty("expression");
            stringsplit.setExpression((String)argOption.valueOf("\n"));
            actors.add(stringsplit);
            StringMatcher stringmatcher = new StringMatcher();
            argOption = (AbstractArgumentOption)stringmatcher.getOptionManager().findByProperty("regExp");
            stringmatcher.setRegExp((BaseRegExp)argOption.valueOf("#.*"));
            stringmatcher.setInvert(true);
            actors.add(stringmatcher);
            StringJoin stringjoin = new StringJoin();
            argOption = (AbstractArgumentOption)stringjoin.getOptionManager().findByProperty("glue");
            stringjoin.setGlue((String)argOption.valueOf("\n"));
            actors.add(stringjoin);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            CurrentFlowTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        CurrentFlowTest.runTest((Test)CurrentFlowTest.suite());
    }
}

